/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryAabbsDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryInstancesDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryTrianglesDataKHR;

public class VkAccelerationStructureGeometryDataKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRIANGLES;
    public static final int AABBS;
    public static final int INSTANCES;

    public VkAccelerationStructureGeometryDataKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureGeometryDataKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
        return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
    }

    public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
        return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
    }

    public VkAccelerationStructureGeometryInstancesDataKHR instances() {
        return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
    }

    public VkAccelerationStructureGeometryDataKHR triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
        consumer.accept(this.triangles());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
        consumer.accept(this.aabbs());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
        consumer.accept(this.instances());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR set(VkAccelerationStructureGeometryDataKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureGeometryDataKHR malloc() {
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR calloc() {
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureGeometryDataKHR create(long address) {
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, address);
    }

    @Nullable
    public static VkAccelerationStructureGeometryDataKHR createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureGeometryDataKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureGeometryDataKHR.__create(capacity, SIZEOF);
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureGeometryDataKHR malloc(MemoryStack stack) {
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR calloc(MemoryStack stack) {
        return VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkAccelerationStructureGeometryTrianglesDataKHR ntriangles(long struct) {
        return VkAccelerationStructureGeometryTrianglesDataKHR.create(struct + (long)TRIANGLES);
    }

    public static VkAccelerationStructureGeometryAabbsDataKHR naabbs(long struct) {
        return VkAccelerationStructureGeometryAabbsDataKHR.create(struct + (long)AABBS);
    }

    public static VkAccelerationStructureGeometryInstancesDataKHR ninstances(long struct) {
        return VkAccelerationStructureGeometryInstancesDataKHR.create(struct + (long)INSTANCES);
    }

    public static void ntriangles(long struct, VkAccelerationStructureGeometryTrianglesDataKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRIANGLES, VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF);
    }

    public static void naabbs(long struct, VkAccelerationStructureGeometryAabbsDataKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)AABBS, VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF);
    }

    public static void ninstances(long struct, VkAccelerationStructureGeometryInstancesDataKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INSTANCES, VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureGeometryDataKHR.__union(VkAccelerationStructureGeometryDataKHR.__member(VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF, VkAccelerationStructureGeometryTrianglesDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member(VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF, VkAccelerationStructureGeometryAabbsDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member(VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF, VkAccelerationStructureGeometryInstancesDataKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRIANGLES = layout.offsetof(0);
        AABBS = layout.offsetof(1);
        INSTANCES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureGeometryDataKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureGeometryDataKHR ELEMENT_FACTORY = VkAccelerationStructureGeometryDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureGeometryDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
            return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
        }

        public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
            return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
        }

        public VkAccelerationStructureGeometryInstancesDataKHR instances() {
            return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
        }

        public Buffer triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
            return this;
        }

        public Buffer triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
            consumer.accept(this.triangles());
            return this;
        }

        public Buffer aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
            return this;
        }

        public Buffer aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
            consumer.accept(this.aabbs());
            return this;
        }

        public Buffer instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
            return this;
        }

        public Buffer instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
            consumer.accept(this.instances());
            return this;
        }
    }
}

