/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkTransformMatrixKHR;

public class VkAccelerationStructureMatrixMotionInstanceNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRANSFORMT0;
    public static final int TRANSFORMT1;
    public static final int BITFIELD0;
    public static final int BITFIELD1;
    public static final int ACCELERATIONSTRUCTUREREFERENCE;

    public VkAccelerationStructureMatrixMotionInstanceNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureMatrixMotionInstanceNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkTransformMatrixKHR transformT0() {
        return VkAccelerationStructureMatrixMotionInstanceNV.ntransformT0(this.address());
    }

    public VkTransformMatrixKHR transformT1() {
        return VkAccelerationStructureMatrixMotionInstanceNV.ntransformT1(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCustomIndex() {
        return VkAccelerationStructureMatrixMotionInstanceNV.ninstanceCustomIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int mask() {
        return VkAccelerationStructureMatrixMotionInstanceNV.nmask(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceShaderBindingTableRecordOffset() {
        return VkAccelerationStructureMatrixMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address());
    }

    @NativeType(value="VkGeometryInstanceFlagsKHR")
    public int flags() {
        return VkAccelerationStructureMatrixMotionInstanceNV.nflags(this.address());
    }

    @NativeType(value="uint64_t")
    public long accelerationStructureReference() {
        return VkAccelerationStructureMatrixMotionInstanceNV.naccelerationStructureReference(this.address());
    }

    public VkAccelerationStructureMatrixMotionInstanceNV transformT0(VkTransformMatrixKHR value) {
        VkAccelerationStructureMatrixMotionInstanceNV.ntransformT0(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV transformT0(Consumer<VkTransformMatrixKHR> consumer) {
        consumer.accept(this.transformT0());
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV transformT1(VkTransformMatrixKHR value) {
        VkAccelerationStructureMatrixMotionInstanceNV.ntransformT1(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV transformT1(Consumer<VkTransformMatrixKHR> consumer) {
        consumer.accept(this.transformT1());
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV instanceCustomIndex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.ninstanceCustomIndex(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV mask(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nmask(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV accelerationStructureReference(@NativeType(value="uint64_t") long value) {
        VkAccelerationStructureMatrixMotionInstanceNV.naccelerationStructureReference(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV set(VkTransformMatrixKHR transformT0, VkTransformMatrixKHR transformT1, int instanceCustomIndex, int mask, int instanceShaderBindingTableRecordOffset, int flags, long accelerationStructureReference) {
        this.transformT0(transformT0);
        this.transformT1(transformT1);
        this.instanceCustomIndex(instanceCustomIndex);
        this.mask(mask);
        this.instanceShaderBindingTableRecordOffset(instanceShaderBindingTableRecordOffset);
        this.flags(flags);
        this.accelerationStructureReference(accelerationStructureReference);
        return this;
    }

    public VkAccelerationStructureMatrixMotionInstanceNV set(VkAccelerationStructureMatrixMotionInstanceNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV malloc() {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV calloc() {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV create(long address) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, address);
    }

    @Nullable
    public static VkAccelerationStructureMatrixMotionInstanceNV createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureMatrixMotionInstanceNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureMatrixMotionInstanceNV.__create(capacity, SIZEOF);
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV malloc(MemoryStack stack) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV calloc(MemoryStack stack) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(VkAccelerationStructureMatrixMotionInstanceNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMatrixMotionInstanceNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkTransformMatrixKHR ntransformT0(long struct) {
        return VkTransformMatrixKHR.create(struct + (long)TRANSFORMT0);
    }

    public static VkTransformMatrixKHR ntransformT1(long struct) {
        return VkTransformMatrixKHR.create(struct + (long)TRANSFORMT1);
    }

    public static int nbitfield0(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD0);
    }

    public static int ninstanceCustomIndex(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct) & 0xFFFFFF;
    }

    public static int nmask(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct) >>> 24;
    }

    public static int nbitfield1(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD1);
    }

    public static int ninstanceShaderBindingTableRecordOffset(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct) & 0xFFFFFF;
    }

    public static int nflags(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct) >>> 24;
    }

    public static long naccelerationStructureReference(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE);
    }

    public static void ntransformT0(long struct, VkTransformMatrixKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSFORMT0, VkTransformMatrixKHR.SIZEOF);
    }

    public static void ntransformT1(long struct, VkTransformMatrixKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSFORMT1, VkTransformMatrixKHR.SIZEOF);
    }

    public static void nbitfield0(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD0, value);
    }

    public static void ninstanceCustomIndex(long struct, int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct, VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nmask(long struct, int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct, value << 24 | VkAccelerationStructureMatrixMotionInstanceNV.nbitfield0(struct) & 0xFFFFFF);
    }

    public static void nbitfield1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD1, value);
    }

    public static void ninstanceShaderBindingTableRecordOffset(long struct, int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct, VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nflags(long struct, int value) {
        VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct, value << 24 | VkAccelerationStructureMatrixMotionInstanceNV.nbitfield1(struct) & 0xFFFFFF);
    }

    public static void naccelerationStructureReference(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureMatrixMotionInstanceNV.__struct(VkAccelerationStructureMatrixMotionInstanceNV.__member(VkTransformMatrixKHR.SIZEOF, VkTransformMatrixKHR.ALIGNOF), VkAccelerationStructureMatrixMotionInstanceNV.__member(VkTransformMatrixKHR.SIZEOF, VkTransformMatrixKHR.ALIGNOF), VkAccelerationStructureMatrixMotionInstanceNV.__member(4), VkAccelerationStructureMatrixMotionInstanceNV.__member(4), VkAccelerationStructureMatrixMotionInstanceNV.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRANSFORMT0 = layout.offsetof(0);
        TRANSFORMT1 = layout.offsetof(1);
        BITFIELD0 = layout.offsetof(2);
        BITFIELD1 = layout.offsetof(3);
        ACCELERATIONSTRUCTUREREFERENCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureMatrixMotionInstanceNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureMatrixMotionInstanceNV ELEMENT_FACTORY = VkAccelerationStructureMatrixMotionInstanceNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureMatrixMotionInstanceNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkTransformMatrixKHR transformT0() {
            return VkAccelerationStructureMatrixMotionInstanceNV.ntransformT0(this.address());
        }

        public VkTransformMatrixKHR transformT1() {
            return VkAccelerationStructureMatrixMotionInstanceNV.ntransformT1(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCustomIndex() {
            return VkAccelerationStructureMatrixMotionInstanceNV.ninstanceCustomIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int mask() {
            return VkAccelerationStructureMatrixMotionInstanceNV.nmask(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceShaderBindingTableRecordOffset() {
            return VkAccelerationStructureMatrixMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address());
        }

        @NativeType(value="VkGeometryInstanceFlagsKHR")
        public int flags() {
            return VkAccelerationStructureMatrixMotionInstanceNV.nflags(this.address());
        }

        @NativeType(value="uint64_t")
        public long accelerationStructureReference() {
            return VkAccelerationStructureMatrixMotionInstanceNV.naccelerationStructureReference(this.address());
        }

        public Buffer transformT0(VkTransformMatrixKHR value) {
            VkAccelerationStructureMatrixMotionInstanceNV.ntransformT0(this.address(), value);
            return this;
        }

        public Buffer transformT0(Consumer<VkTransformMatrixKHR> consumer) {
            consumer.accept(this.transformT0());
            return this;
        }

        public Buffer transformT1(VkTransformMatrixKHR value) {
            VkAccelerationStructureMatrixMotionInstanceNV.ntransformT1(this.address(), value);
            return this;
        }

        public Buffer transformT1(Consumer<VkTransformMatrixKHR> consumer) {
            consumer.accept(this.transformT1());
            return this;
        }

        public Buffer instanceCustomIndex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureMatrixMotionInstanceNV.ninstanceCustomIndex(this.address(), value);
            return this;
        }

        public Buffer mask(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureMatrixMotionInstanceNV.nmask(this.address(), value);
            return this;
        }

        public Buffer instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureMatrixMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
            VkAccelerationStructureMatrixMotionInstanceNV.nflags(this.address(), value);
            return this;
        }

        public Buffer accelerationStructureReference(@NativeType(value="uint64_t") long value) {
            VkAccelerationStructureMatrixMotionInstanceNV.naccelerationStructureReference(this.address(), value);
            return this;
        }
    }
}

