/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureMotionInstanceDataNV;

public class VkAccelerationStructureMotionInstanceNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int DATA;

    public VkAccelerationStructureMotionInstanceNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureMotionInstanceNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkAccelerationStructureMotionInstanceTypeNV")
    public int type() {
        return VkAccelerationStructureMotionInstanceNV.ntype(this.address());
    }

    @NativeType(value="VkAccelerationStructureMotionInstanceFlagsNV")
    public int flags() {
        return VkAccelerationStructureMotionInstanceNV.nflags(this.address());
    }

    public VkAccelerationStructureMotionInstanceDataNV data() {
        return VkAccelerationStructureMotionInstanceNV.ndata(this.address());
    }

    public VkAccelerationStructureMotionInstanceNV type(@NativeType(value="VkAccelerationStructureMotionInstanceTypeNV") int value) {
        VkAccelerationStructureMotionInstanceNV.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceNV flags(@NativeType(value="VkAccelerationStructureMotionInstanceFlagsNV") int value) {
        VkAccelerationStructureMotionInstanceNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceNV data(VkAccelerationStructureMotionInstanceDataNV value) {
        VkAccelerationStructureMotionInstanceNV.ndata(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceNV data(Consumer<VkAccelerationStructureMotionInstanceDataNV> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public VkAccelerationStructureMotionInstanceNV set(int type, int flags, VkAccelerationStructureMotionInstanceDataNV data) {
        this.type(type);
        this.flags(flags);
        this.data(data);
        return this;
    }

    public VkAccelerationStructureMotionInstanceNV set(VkAccelerationStructureMotionInstanceNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureMotionInstanceNV malloc() {
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceNV calloc() {
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureMotionInstanceNV create(long address) {
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, address);
    }

    @Nullable
    public static VkAccelerationStructureMotionInstanceNV createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureMotionInstanceNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureMotionInstanceNV.__create(capacity, SIZEOF);
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureMotionInstanceNV malloc(MemoryStack stack) {
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceNV calloc(MemoryStack stack) {
        return VkAccelerationStructureMotionInstanceNV.wrap(VkAccelerationStructureMotionInstanceNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMotionInstanceNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkAccelerationStructureMotionInstanceDataNV ndata(long struct) {
        return VkAccelerationStructureMotionInstanceDataNV.create(struct + (long)DATA);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndata(long struct, VkAccelerationStructureMotionInstanceDataNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DATA, VkAccelerationStructureMotionInstanceDataNV.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureMotionInstanceNV.__struct(VkAccelerationStructureMotionInstanceNV.__member(4), VkAccelerationStructureMotionInstanceNV.__member(4), VkAccelerationStructureMotionInstanceNV.__member(VkAccelerationStructureMotionInstanceDataNV.SIZEOF, VkAccelerationStructureMotionInstanceDataNV.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureMotionInstanceNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureMotionInstanceNV ELEMENT_FACTORY = VkAccelerationStructureMotionInstanceNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureMotionInstanceNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkAccelerationStructureMotionInstanceTypeNV")
        public int type() {
            return VkAccelerationStructureMotionInstanceNV.ntype(this.address());
        }

        @NativeType(value="VkAccelerationStructureMotionInstanceFlagsNV")
        public int flags() {
            return VkAccelerationStructureMotionInstanceNV.nflags(this.address());
        }

        public VkAccelerationStructureMotionInstanceDataNV data() {
            return VkAccelerationStructureMotionInstanceNV.ndata(this.address());
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureMotionInstanceTypeNV") int value) {
            VkAccelerationStructureMotionInstanceNV.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkAccelerationStructureMotionInstanceFlagsNV") int value) {
            VkAccelerationStructureMotionInstanceNV.nflags(this.address(), value);
            return this;
        }

        public Buffer data(VkAccelerationStructureMotionInstanceDataNV value) {
            VkAccelerationStructureMotionInstanceNV.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<VkAccelerationStructureMotionInstanceDataNV> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

