/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBaseInStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    public VkBaseInStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBaseInStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBaseInStructure.nsType(this.address());
    }

    @Nullable
    @NativeType(value="VkBaseInStructure const *")
    public VkBaseInStructure pNext() {
        return VkBaseInStructure.npNext(this.address());
    }

    public VkBaseInStructure sType(@NativeType(value="VkStructureType") int value) {
        VkBaseInStructure.nsType(this.address(), value);
        return this;
    }

    public VkBaseInStructure pNext(@Nullable @NativeType(value="VkBaseInStructure const *") VkBaseInStructure value) {
        VkBaseInStructure.npNext(this.address(), value);
        return this;
    }

    public VkBaseInStructure set(int sType, @Nullable VkBaseInStructure pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkBaseInStructure set(VkBaseInStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBaseInStructure malloc() {
        return VkBaseInStructure.wrap(VkBaseInStructure.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBaseInStructure calloc() {
        return VkBaseInStructure.wrap(VkBaseInStructure.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBaseInStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBaseInStructure.wrap(VkBaseInStructure.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBaseInStructure create(long address) {
        return VkBaseInStructure.wrap(VkBaseInStructure.class, address);
    }

    @Nullable
    public static VkBaseInStructure createSafe(long address) {
        return address == 0L ? null : VkBaseInStructure.wrap(VkBaseInStructure.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBaseInStructure.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBaseInStructure.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBaseInStructure.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBaseInStructure.__create(capacity, SIZEOF);
        return VkBaseInStructure.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBaseInStructure.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBaseInStructure.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBaseInStructure mallocStack() {
        return VkBaseInStructure.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseInStructure callocStack() {
        return VkBaseInStructure.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseInStructure mallocStack(MemoryStack stack) {
        return VkBaseInStructure.malloc(stack);
    }

    @Deprecated
    public static VkBaseInStructure callocStack(MemoryStack stack) {
        return VkBaseInStructure.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBaseInStructure.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBaseInStructure.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBaseInStructure.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBaseInStructure.calloc(capacity, stack);
    }

    public static VkBaseInStructure malloc(MemoryStack stack) {
        return VkBaseInStructure.wrap(VkBaseInStructure.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBaseInStructure calloc(MemoryStack stack) {
        return VkBaseInStructure.wrap(VkBaseInStructure.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBaseInStructure.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBaseInStructure.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    @Nullable
    public static VkBaseInStructure npNext(long struct) {
        return VkBaseInStructure.createSafe(MemoryUtil.memGetAddress(struct + (long)PNEXT));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, @Nullable VkBaseInStructure value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkBaseInStructure.__struct(VkBaseInStructure.__member(4), VkBaseInStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkBaseInStructure, Buffer>
    implements NativeResource {
        private static final VkBaseInStructure ELEMENT_FACTORY = VkBaseInStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBaseInStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBaseInStructure.nsType(this.address());
        }

        @Nullable
        @NativeType(value="VkBaseInStructure const *")
        public VkBaseInStructure pNext() {
            return VkBaseInStructure.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBaseInStructure.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@Nullable @NativeType(value="VkBaseInStructure const *") VkBaseInStructure value) {
            VkBaseInStructure.npNext(this.address(), value);
            return this;
        }
    }
}

