/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImageMemoryInfo;

public class VkBindImageMemoryInfoKHR
extends VkBindImageMemoryInfo {
    public VkBindImageMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindImageMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR sType$Default() {
        return this.sType(1000157001);
    }

    @Override
    public VkBindImageMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR image(@NativeType(value="VkImage") long value) {
        VkBindImageMemoryInfoKHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindImageMemoryInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindImageMemoryInfoKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR set(int sType, long pNext, long image, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindImageMemoryInfoKHR set(VkBindImageMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryInfoKHR malloc() {
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR calloc() {
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBindImageMemoryInfoKHR create(long address) {
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, address);
    }

    @Nullable
    public static VkBindImageMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBindImageMemoryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImageMemoryInfoKHR.__create(capacity, SIZEOF);
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImageMemoryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBindImageMemoryInfoKHR mallocStack() {
        return VkBindImageMemoryInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryInfoKHR callocStack() {
        return VkBindImageMemoryInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkBindImageMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.calloc(capacity, stack);
    }

    public static VkBindImageMemoryInfoKHR malloc(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR calloc(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.wrap(VkBindImageMemoryInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImageMemoryInfo.Buffer {
        private static final VkBindImageMemoryInfoKHR ELEMENT_FACTORY = VkBindImageMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindImageMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000157001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkBindImageMemoryInfoKHR.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindImageMemoryInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindImageMemoryInfoKHR.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

