/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferOpaqueCaptureAddressCreateInfo;

public class VkBufferOpaqueCaptureAddressCreateInfoKHR
extends VkBufferOpaqueCaptureAddressCreateInfo {
    public VkBufferOpaqueCaptureAddressCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferOpaqueCaptureAddressCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferOpaqueCaptureAddressCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferOpaqueCaptureAddressCreateInfoKHR sType$Default() {
        return this.sType(1000257002);
    }

    @Override
    public VkBufferOpaqueCaptureAddressCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBufferOpaqueCaptureAddressCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferOpaqueCaptureAddressCreateInfoKHR opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkBufferOpaqueCaptureAddressCreateInfoKHR.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    @Override
    public VkBufferOpaqueCaptureAddressCreateInfoKHR set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkBufferOpaqueCaptureAddressCreateInfoKHR set(VkBufferOpaqueCaptureAddressCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR malloc() {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR calloc() {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR create(long address) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkBufferOpaqueCaptureAddressCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferOpaqueCaptureAddressCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferOpaqueCaptureAddressCreateInfoKHR.__create(capacity, SIZEOF);
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR malloc(MemoryStack stack) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferOpaqueCaptureAddressCreateInfoKHR calloc(MemoryStack stack) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(VkBufferOpaqueCaptureAddressCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferOpaqueCaptureAddressCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferOpaqueCaptureAddressCreateInfo.Buffer {
        private static final VkBufferOpaqueCaptureAddressCreateInfoKHR ELEMENT_FACTORY = VkBufferOpaqueCaptureAddressCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferOpaqueCaptureAddressCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferOpaqueCaptureAddressCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000257002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferOpaqueCaptureAddressCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkBufferOpaqueCaptureAddressCreateInfoKHR.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

