/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandBufferAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COMMANDPOOL;
    public static final int LEVEL;
    public static final int COMMANDBUFFERCOUNT;

    public VkCommandBufferAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCommandBufferAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkCommandPool")
    public long commandPool() {
        return VkCommandBufferAllocateInfo.ncommandPool(this.address());
    }

    @NativeType(value="VkCommandBufferLevel")
    public int level() {
        return VkCommandBufferAllocateInfo.nlevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int commandBufferCount() {
        return VkCommandBufferAllocateInfo.ncommandBufferCount(this.address());
    }

    public VkCommandBufferAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo sType$Default() {
        return this.sType(40);
    }

    public VkCommandBufferAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo commandPool(@NativeType(value="VkCommandPool") long value) {
        VkCommandBufferAllocateInfo.ncommandPool(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo level(@NativeType(value="VkCommandBufferLevel") int value) {
        VkCommandBufferAllocateInfo.nlevel(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo commandBufferCount(@NativeType(value="uint32_t") int value) {
        VkCommandBufferAllocateInfo.ncommandBufferCount(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo set(int sType, long pNext, long commandPool, int level, int commandBufferCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.commandPool(commandPool);
        this.level(level);
        this.commandBufferCount(commandBufferCount);
        return this;
    }

    public VkCommandBufferAllocateInfo set(VkCommandBufferAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferAllocateInfo malloc() {
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCommandBufferAllocateInfo calloc() {
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCommandBufferAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkCommandBufferAllocateInfo create(long address) {
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, address);
    }

    @Nullable
    public static VkCommandBufferAllocateInfo createSafe(long address) {
        return address == 0L ? null : VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkCommandBufferAllocateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandBufferAllocateInfo.__create(capacity, SIZEOF);
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCommandBufferAllocateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkCommandBufferAllocateInfo mallocStack() {
        return VkCommandBufferAllocateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandBufferAllocateInfo callocStack() {
        return VkCommandBufferAllocateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandBufferAllocateInfo mallocStack(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.malloc(stack);
    }

    @Deprecated
    public static VkCommandBufferAllocateInfo callocStack(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferAllocateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCommandBufferAllocateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.calloc(capacity, stack);
    }

    public static VkCommandBufferAllocateInfo malloc(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferAllocateInfo calloc(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.wrap(VkCommandBufferAllocateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ncommandPool(long struct) {
        return UNSAFE.getLong(null, struct + (long)COMMANDPOOL);
    }

    public static int nlevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL);
    }

    public static int ncommandBufferCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMANDBUFFERCOUNT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncommandPool(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)COMMANDPOOL, value);
    }

    public static void nlevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL, value);
    }

    public static void ncommandBufferCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMMANDBUFFERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkCommandBufferAllocateInfo.__struct(VkCommandBufferAllocateInfo.__member(4), VkCommandBufferAllocateInfo.__member(POINTER_SIZE), VkCommandBufferAllocateInfo.__member(8), VkCommandBufferAllocateInfo.__member(4), VkCommandBufferAllocateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COMMANDPOOL = layout.offsetof(2);
        LEVEL = layout.offsetof(3);
        COMMANDBUFFERCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkCommandBufferAllocateInfo ELEMENT_FACTORY = VkCommandBufferAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCommandBufferAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkCommandPool")
        public long commandPool() {
            return VkCommandBufferAllocateInfo.ncommandPool(this.address());
        }

        @NativeType(value="VkCommandBufferLevel")
        public int level() {
            return VkCommandBufferAllocateInfo.nlevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int commandBufferCount() {
            return VkCommandBufferAllocateInfo.ncommandBufferCount(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(40);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer commandPool(@NativeType(value="VkCommandPool") long value) {
            VkCommandBufferAllocateInfo.ncommandPool(this.address(), value);
            return this;
        }

        public Buffer level(@NativeType(value="VkCommandBufferLevel") int value) {
            VkCommandBufferAllocateInfo.nlevel(this.address(), value);
            return this;
        }

        public Buffer commandBufferCount(@NativeType(value="uint32_t") int value) {
            VkCommandBufferAllocateInfo.ncommandBufferCount(this.address(), value);
            return this;
        }
    }
}

