/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBufferInheritanceInfo;
import org.lwjgl.vulkan.VkDeviceGroupCommandBufferBeginInfo;
import org.lwjgl.vulkan.VkDeviceGroupCommandBufferBeginInfoKHR;

public class VkCommandBufferBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PINHERITANCEINFO;

    public VkCommandBufferBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCommandBufferBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkCommandBufferUsageFlags")
    public int flags() {
        return VkCommandBufferBeginInfo.nflags(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBufferInheritanceInfo const *")
    public VkCommandBufferInheritanceInfo pInheritanceInfo() {
        return VkCommandBufferBeginInfo.npInheritanceInfo(this.address());
    }

    public VkCommandBufferBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo sType$Default() {
        return this.sType(42);
    }

    public VkCommandBufferBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo pNext(VkDeviceGroupCommandBufferBeginInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkCommandBufferBeginInfo pNext(VkDeviceGroupCommandBufferBeginInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkCommandBufferBeginInfo flags(@NativeType(value="VkCommandBufferUsageFlags") int value) {
        VkCommandBufferBeginInfo.nflags(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo pInheritanceInfo(@Nullable @NativeType(value="VkCommandBufferInheritanceInfo const *") VkCommandBufferInheritanceInfo value) {
        VkCommandBufferBeginInfo.npInheritanceInfo(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo set(int sType, long pNext, int flags, @Nullable VkCommandBufferInheritanceInfo pInheritanceInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pInheritanceInfo(pInheritanceInfo);
        return this;
    }

    public VkCommandBufferBeginInfo set(VkCommandBufferBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferBeginInfo malloc() {
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCommandBufferBeginInfo calloc() {
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCommandBufferBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkCommandBufferBeginInfo create(long address) {
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, address);
    }

    @Nullable
    public static VkCommandBufferBeginInfo createSafe(long address) {
        return address == 0L ? null : VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandBufferBeginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkCommandBufferBeginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandBufferBeginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandBufferBeginInfo.__create(capacity, SIZEOF);
        return VkCommandBufferBeginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkCommandBufferBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCommandBufferBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkCommandBufferBeginInfo mallocStack() {
        return VkCommandBufferBeginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandBufferBeginInfo callocStack() {
        return VkCommandBufferBeginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandBufferBeginInfo mallocStack(MemoryStack stack) {
        return VkCommandBufferBeginInfo.malloc(stack);
    }

    @Deprecated
    public static VkCommandBufferBeginInfo callocStack(MemoryStack stack) {
        return VkCommandBufferBeginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferBeginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCommandBufferBeginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferBeginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferBeginInfo.calloc(capacity, stack);
    }

    public static VkCommandBufferBeginInfo malloc(MemoryStack stack) {
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferBeginInfo calloc(MemoryStack stack) {
        return VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkCommandBufferBeginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkCommandBufferBeginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static VkCommandBufferInheritanceInfo npInheritanceInfo(long struct) {
        return VkCommandBufferInheritanceInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PINHERITANCEINFO));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npInheritanceInfo(long struct, @Nullable VkCommandBufferInheritanceInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PINHERITANCEINFO, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkCommandBufferBeginInfo.__struct(VkCommandBufferBeginInfo.__member(4), VkCommandBufferBeginInfo.__member(POINTER_SIZE), VkCommandBufferBeginInfo.__member(4), VkCommandBufferBeginInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PINHERITANCEINFO = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferBeginInfo, Buffer>
    implements NativeResource {
        private static final VkCommandBufferBeginInfo ELEMENT_FACTORY = VkCommandBufferBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCommandBufferBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkCommandBufferUsageFlags")
        public int flags() {
            return VkCommandBufferBeginInfo.nflags(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBufferInheritanceInfo const *")
        public VkCommandBufferInheritanceInfo pInheritanceInfo() {
            return VkCommandBufferBeginInfo.npInheritanceInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(42);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupCommandBufferBeginInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupCommandBufferBeginInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkCommandBufferUsageFlags") int value) {
            VkCommandBufferBeginInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pInheritanceInfo(@Nullable @NativeType(value="VkCommandBufferInheritanceInfo const *") VkCommandBufferInheritanceInfo value) {
            VkCommandBufferBeginInfo.npInheritanceInfo(this.address(), value);
            return this;
        }
    }
}

