/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkConformanceVersion;

public class VkConformanceVersionKHR
extends VkConformanceVersion {
    public VkConformanceVersionKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkConformanceVersionKHR major(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nmajor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR minor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nminor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR subminor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nsubminor(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR patch(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.npatch(this.address(), value);
        return this;
    }

    @Override
    public VkConformanceVersionKHR set(byte major, byte minor, byte subminor, byte patch) {
        this.major(major);
        this.minor(minor);
        this.subminor(subminor);
        this.patch(patch);
        return this;
    }

    public VkConformanceVersionKHR set(VkConformanceVersionKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkConformanceVersionKHR malloc() {
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkConformanceVersionKHR calloc() {
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkConformanceVersionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkConformanceVersionKHR create(long address) {
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, address);
    }

    @Nullable
    public static VkConformanceVersionKHR createSafe(long address) {
        return address == 0L ? null : VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkConformanceVersionKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkConformanceVersionKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkConformanceVersionKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkConformanceVersionKHR.__create(capacity, SIZEOF);
        return VkConformanceVersionKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkConformanceVersionKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkConformanceVersionKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkConformanceVersionKHR mallocStack() {
        return VkConformanceVersionKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkConformanceVersionKHR callocStack() {
        return VkConformanceVersionKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkConformanceVersionKHR mallocStack(MemoryStack stack) {
        return VkConformanceVersionKHR.malloc(stack);
    }

    @Deprecated
    public static VkConformanceVersionKHR callocStack(MemoryStack stack) {
        return VkConformanceVersionKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkConformanceVersionKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkConformanceVersionKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.calloc(capacity, stack);
    }

    public static VkConformanceVersionKHR malloc(MemoryStack stack) {
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkConformanceVersionKHR calloc(MemoryStack stack) {
        return VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkConformanceVersionKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkConformanceVersion.Buffer {
        private static final VkConformanceVersionKHR ELEMENT_FACTORY = VkConformanceVersionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkConformanceVersionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer major(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nmajor(this.address(), value);
            return this;
        }

        @Override
        public Buffer minor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nminor(this.address(), value);
            return this;
        }

        @Override
        public Buffer subminor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nsubminor(this.address(), value);
            return this;
        }

        @Override
        public Buffer patch(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.npatch(this.address(), value);
            return this;
        }
    }
}

