/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCopyAccelerationStructureInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRC;
    public static final int DST;
    public static final int MODE;

    public VkCopyAccelerationStructureInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyAccelerationStructureInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyAccelerationStructureInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyAccelerationStructureInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long src() {
        return VkCopyAccelerationStructureInfoKHR.nsrc(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long dst() {
        return VkCopyAccelerationStructureInfoKHR.ndst(this.address());
    }

    @NativeType(value="VkCopyAccelerationStructureModeKHR")
    public int mode() {
        return VkCopyAccelerationStructureInfoKHR.nmode(this.address());
    }

    public VkCopyAccelerationStructureInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkCopyAccelerationStructureInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR sType$Default() {
        return this.sType(1000150010);
    }

    public VkCopyAccelerationStructureInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkCopyAccelerationStructureInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR src(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkCopyAccelerationStructureInfoKHR.nsrc(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR dst(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkCopyAccelerationStructureInfoKHR.ndst(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
        VkCopyAccelerationStructureInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR set(int sType, long pNext, long src, long dst, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.src(src);
        this.dst(dst);
        this.mode(mode);
        return this;
    }

    public VkCopyAccelerationStructureInfoKHR set(VkCopyAccelerationStructureInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyAccelerationStructureInfoKHR malloc() {
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCopyAccelerationStructureInfoKHR calloc() {
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCopyAccelerationStructureInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkCopyAccelerationStructureInfoKHR create(long address) {
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, address);
    }

    @Nullable
    public static VkCopyAccelerationStructureInfoKHR createSafe(long address) {
        return address == 0L ? null : VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkCopyAccelerationStructureInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyAccelerationStructureInfoKHR.__create(capacity, SIZEOF);
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkCopyAccelerationStructureInfoKHR malloc(MemoryStack stack) {
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCopyAccelerationStructureInfoKHR calloc(MemoryStack stack) {
        return VkCopyAccelerationStructureInfoKHR.wrap(VkCopyAccelerationStructureInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkCopyAccelerationStructureInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrc(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRC);
    }

    public static long ndst(long struct) {
        return UNSAFE.getLong(null, struct + (long)DST);
    }

    public static int nmode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrc(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRC, value);
    }

    public static void ndst(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DST, value);
    }

    public static void nmode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODE, value);
    }

    static {
        Struct.Layout layout = VkCopyAccelerationStructureInfoKHR.__struct(VkCopyAccelerationStructureInfoKHR.__member(4), VkCopyAccelerationStructureInfoKHR.__member(POINTER_SIZE), VkCopyAccelerationStructureInfoKHR.__member(8), VkCopyAccelerationStructureInfoKHR.__member(8), VkCopyAccelerationStructureInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRC = layout.offsetof(2);
        DST = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCopyAccelerationStructureInfoKHR, Buffer>
    implements NativeResource {
        private static final VkCopyAccelerationStructureInfoKHR ELEMENT_FACTORY = VkCopyAccelerationStructureInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyAccelerationStructureInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyAccelerationStructureInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyAccelerationStructureInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long src() {
            return VkCopyAccelerationStructureInfoKHR.nsrc(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long dst() {
            return VkCopyAccelerationStructureInfoKHR.ndst(this.address());
        }

        @NativeType(value="VkCopyAccelerationStructureModeKHR")
        public int mode() {
            return VkCopyAccelerationStructureInfoKHR.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyAccelerationStructureInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150010);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyAccelerationStructureInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer src(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkCopyAccelerationStructureInfoKHR.nsrc(this.address(), value);
            return this;
        }

        public Buffer dst(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkCopyAccelerationStructureInfoKHR.ndst(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
            VkCopyAccelerationStructureInfoKHR.nmode(this.address(), value);
            return this;
        }
    }
}

