/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectNameInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int POBJECTNAME;

    public VkDebugMarkerObjectNameInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDebugMarkerObjectNameInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugReportObjectTypeEXT")
    public int objectType() {
        return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long object() {
        return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pObjectName() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
    }

    @NativeType(value="char const *")
    public String pObjectNameString() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
    }

    public VkDebugMarkerObjectNameInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT sType$Default() {
        return this.sType(1000022000);
    }

    public VkDebugMarkerObjectNameInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
        VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT object(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT pObjectName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(int sType, long pNext, int objectType, long object, ByteBuffer pObjectName) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.pObjectName(pObjectName);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(VkDebugMarkerObjectNameInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugMarkerObjectNameInfoEXT malloc() {
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT calloc() {
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDebugMarkerObjectNameInfoEXT create(long address) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, address);
    }

    @Nullable
    public static VkDebugMarkerObjectNameInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDebugMarkerObjectNameInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugMarkerObjectNameInfoEXT.__create(capacity, SIZEOF);
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT mallocStack() {
        return VkDebugMarkerObjectNameInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT callocStack() {
        return VkDebugMarkerObjectNameInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugMarkerObjectNameInfoEXT malloc(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT calloc(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECT);
    }

    public static ByteBuffer npObjectName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    public static String npObjectNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECT, value);
    }

    public static void npObjectName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)POBJECTNAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectNameInfoEXT.__struct(VkDebugMarkerObjectNameInfoEXT.__member(4), VkDebugMarkerObjectNameInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectNameInfoEXT.__member(4), VkDebugMarkerObjectNameInfoEXT.__member(8), VkDebugMarkerObjectNameInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        POBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerObjectNameInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugMarkerObjectNameInfoEXT ELEMENT_FACTORY = VkDebugMarkerObjectNameInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDebugMarkerObjectNameInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugReportObjectTypeEXT")
        public int objectType() {
            return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long object() {
            return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pObjectName() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
        }

        @NativeType(value="char const *")
        public String pObjectNameString() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000022000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
            VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer pObjectName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
            return this;
        }
    }
}

