/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBinding;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBindingFlagsCreateInfo;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBindingFlagsCreateInfoEXT;
import org.lwjgl.vulkan.VkMutableDescriptorTypeCreateInfoVALVE;

public class VkDescriptorSetLayoutCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BINDINGCOUNT;
    public static final int PBINDINGS;

    public VkDescriptorSetLayoutCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorSetLayoutCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSetLayoutCreateFlags")
    public int flags() {
        return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindingCount() {
        return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorSetLayoutBinding const *")
    public VkDescriptorSetLayoutBinding.Buffer pBindings() {
        return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
    }

    public VkDescriptorSetLayoutCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo sType$Default() {
        return this.sType(32);
    }

    public VkDescriptorSetLayoutCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkDescriptorSetLayoutBindingFlagsCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
        VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
        VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(int sType, long pNext, int flags, @Nullable VkDescriptorSetLayoutBinding.Buffer pBindings) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pBindings(pBindings);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(VkDescriptorSetLayoutCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutCreateInfo malloc() {
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo calloc() {
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorSetLayoutCreateInfo create(long address) {
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, address);
    }

    @Nullable
    public static VkDescriptorSetLayoutCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDescriptorSetLayoutCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetLayoutCreateInfo.__create(capacity, SIZEOF);
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo mallocStack() {
        return VkDescriptorSetLayoutCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo callocStack() {
        return VkDescriptorSetLayoutCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.calloc(capacity, stack);
    }

    public static VkDescriptorSetLayoutCreateInfo malloc(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo calloc(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.wrap(VkDescriptorSetLayoutCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nbindingCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDINGCOUNT);
    }

    @Nullable
    public static VkDescriptorSetLayoutBinding.Buffer npBindings(long struct) {
        return VkDescriptorSetLayoutBinding.createSafe(MemoryUtil.memGetAddress(struct + (long)PBINDINGS), VkDescriptorSetLayoutCreateInfo.nbindingCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nbindingCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDINGCOUNT, value);
    }

    public static void npBindings(long struct, @Nullable VkDescriptorSetLayoutBinding.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDINGS, MemoryUtil.memAddressSafe(value));
        VkDescriptorSetLayoutCreateInfo.nbindingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDescriptorSetLayoutCreateInfo.nbindingCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDINGS));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutCreateInfo.__struct(VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(POINTER_SIZE), VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BINDINGCOUNT = layout.offsetof(3);
        PBINDINGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetLayoutCreateInfo ELEMENT_FACTORY = VkDescriptorSetLayoutCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDescriptorSetLayoutCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSetLayoutCreateFlags")
        public int flags() {
            return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindingCount() {
            return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorSetLayoutBinding const *")
        public VkDescriptorSetLayoutBinding.Buffer pBindings() {
            return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(32);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDescriptorSetLayoutBindingFlagsCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
            VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
            VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
            return this;
        }
    }
}

