/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupPresentCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRESENTMASK;
    public static final int MODES;

    public VkDeviceGroupPresentCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceGroupPresentCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t[VK_MAX_DEVICE_GROUP_SIZE]")
    public IntBuffer presentMask() {
        return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int presentMask(int index) {
        return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address(), index);
    }

    @NativeType(value="VkDeviceGroupPresentModeFlagsKHR")
    public int modes() {
        return VkDeviceGroupPresentCapabilitiesKHR.nmodes(this.address());
    }

    public VkDeviceGroupPresentCapabilitiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR sType$Default() {
        return this.sType(1000060007);
    }

    public VkDeviceGroupPresentCapabilitiesKHR pNext(@NativeType(value="void *") long value) {
        VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR set(VkDeviceGroupPresentCapabilitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupPresentCapabilitiesKHR malloc() {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR calloc() {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceGroupPresentCapabilitiesKHR create(long address) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, address);
    }

    @Nullable
    public static VkDeviceGroupPresentCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDeviceGroupPresentCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupPresentCapabilitiesKHR.__create(capacity, SIZEOF);
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupPresentCapabilitiesKHR mallocStack() {
        return VkDeviceGroupPresentCapabilitiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupPresentCapabilitiesKHR callocStack() {
        return VkDeviceGroupPresentCapabilitiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupPresentCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupPresentCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.calloc(capacity, stack);
    }

    public static VkDeviceGroupPresentCapabilitiesKHR malloc(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR calloc(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(VkDeviceGroupPresentCapabilitiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static IntBuffer npresentMask(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)PRESENTMASK, 32);
    }

    public static int npresentMask(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)PRESENTMASK + Checks.check(index, 32) * 4L);
    }

    public static int nmodes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupPresentCapabilitiesKHR.__struct(VkDeviceGroupPresentCapabilitiesKHR.__member(4), VkDeviceGroupPresentCapabilitiesKHR.__member(POINTER_SIZE), VkDeviceGroupPresentCapabilitiesKHR.__array(4, 32), VkDeviceGroupPresentCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRESENTMASK = layout.offsetof(2);
        MODES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupPresentCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupPresentCapabilitiesKHR ELEMENT_FACTORY = VkDeviceGroupPresentCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceGroupPresentCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t[VK_MAX_DEVICE_GROUP_SIZE]")
        public IntBuffer presentMask() {
            return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int presentMask(int index) {
            return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address(), index);
        }

        @NativeType(value="VkDeviceGroupPresentModeFlagsKHR")
        public int modes() {
            return VkDeviceGroupPresentCapabilitiesKHR.nmodes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060007);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address(), value);
            return this;
        }
    }
}

