/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceOrHostAddressConstKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int HOSTADDRESS;

    public VkDeviceOrHostAddressConstKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceOrHostAddressConstKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="void const *")
    public long hostAddress() {
        return VkDeviceOrHostAddressConstKHR.nhostAddress(this.address());
    }

    public VkDeviceOrHostAddressConstKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstKHR hostAddress(@NativeType(value="void const *") long value) {
        VkDeviceOrHostAddressConstKHR.nhostAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstKHR set(VkDeviceOrHostAddressConstKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceOrHostAddressConstKHR malloc() {
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR calloc() {
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceOrHostAddressConstKHR create(long address) {
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, address);
    }

    @Nullable
    public static VkDeviceOrHostAddressConstKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDeviceOrHostAddressConstKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceOrHostAddressConstKHR.__create(capacity, SIZEOF);
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkDeviceOrHostAddressConstKHR malloc(MemoryStack stack) {
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR calloc(MemoryStack stack) {
        return VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nhostAddress(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HOSTADDRESS);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nhostAddress(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HOSTADDRESS, value);
    }

    static {
        Struct.Layout layout = VkDeviceOrHostAddressConstKHR.__union(VkDeviceOrHostAddressConstKHR.__member(8), VkDeviceOrHostAddressConstKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        HOSTADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceOrHostAddressConstKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceOrHostAddressConstKHR ELEMENT_FACTORY = VkDeviceOrHostAddressConstKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceOrHostAddressConstKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="void const *")
        public long hostAddress() {
            return VkDeviceOrHostAddressConstKHR.nhostAddress(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer hostAddress(@NativeType(value="void const *") long value) {
            VkDeviceOrHostAddressConstKHR.nhostAddress(this.address(), value);
            return this;
        }
    }
}

