/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModeCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PARAMETERS;

    public VkDisplayModeCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayModeCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayModeCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayModeCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDisplayModeCreateFlagsKHR")
    public int flags() {
        return VkDisplayModeCreateInfoKHR.nflags(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModeCreateInfoKHR.nparameters(this.address());
    }

    public VkDisplayModeCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR sType$Default() {
        return this.sType(1000002000);
    }

    public VkDisplayModeCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
        VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(VkDisplayModeParametersKHR value) {
        VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
        consumer.accept(this.parameters());
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(int sType, long pNext, int flags, VkDisplayModeParametersKHR parameters) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.parameters(parameters);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(VkDisplayModeCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDisplayModeCreateInfoKHR malloc() {
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR calloc() {
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayModeCreateInfoKHR create(long address) {
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkDisplayModeCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDisplayModeCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModeCreateInfoKHR.__create(capacity, SIZEOF);
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayModeCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR mallocStack() {
        return VkDisplayModeCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR callocStack() {
        return VkDisplayModeCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR callocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkDisplayModeCreateInfoKHR malloc(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR calloc(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nparameters(long struct, VkDisplayModeParametersKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARAMETERS, VkDisplayModeParametersKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDisplayModeCreateInfoKHR.__struct(VkDisplayModeCreateInfoKHR.__member(4), VkDisplayModeCreateInfoKHR.__member(POINTER_SIZE), VkDisplayModeCreateInfoKHR.__member(4), VkDisplayModeCreateInfoKHR.__member(VkDisplayModeParametersKHR.SIZEOF, VkDisplayModeParametersKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PARAMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModeCreateInfoKHR ELEMENT_FACTORY = VkDisplayModeCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDisplayModeCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayModeCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayModeCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDisplayModeCreateFlagsKHR")
        public int flags() {
            return VkDisplayModeCreateInfoKHR.nflags(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModeCreateInfoKHR.nparameters(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000002000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
            VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer parameters(VkDisplayModeParametersKHR value) {
            VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
            return this;
        }

        public Buffer parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
            consumer.accept(this.parameters());
            return this;
        }
    }
}

