/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModePropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DISPLAYMODE;
    public static final int PARAMETERS;

    public VkDisplayModePropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayModePropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayModeKHR")
    public long displayMode() {
        return VkDisplayModePropertiesKHR.ndisplayMode(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModePropertiesKHR.nparameters(this.address());
    }

    public static VkDisplayModePropertiesKHR malloc() {
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayModePropertiesKHR calloc() {
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayModePropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayModePropertiesKHR create(long address) {
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, address);
    }

    @Nullable
    public static VkDisplayModePropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDisplayModePropertiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModePropertiesKHR.__create(capacity, SIZEOF);
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayModePropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDisplayModePropertiesKHR mallocStack() {
        return VkDisplayModePropertiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModePropertiesKHR callocStack() {
        return VkDisplayModePropertiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModePropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayModePropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayModePropertiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayModePropertiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.calloc(capacity, stack);
    }

    public static VkDisplayModePropertiesKHR malloc(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModePropertiesKHR calloc(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.wrap(VkDisplayModePropertiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndisplayMode(long struct) {
        return UNSAFE.getLong(null, struct + (long)DISPLAYMODE);
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    static {
        Struct.Layout layout = VkDisplayModePropertiesKHR.__struct(VkDisplayModePropertiesKHR.__member(8), VkDisplayModePropertiesKHR.__member(VkDisplayModeParametersKHR.SIZEOF, VkDisplayModeParametersKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DISPLAYMODE = layout.offsetof(0);
        PARAMETERS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModePropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModePropertiesKHR ELEMENT_FACTORY = VkDisplayModePropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDisplayModePropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDisplayModeKHR")
        public long displayMode() {
            return VkDisplayModePropertiesKHR.ndisplayMode(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModePropertiesKHR.nparameters(this.address());
        }
    }
}

