/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkEventCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    public VkEventCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkEventCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkEventCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkEventCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkEventCreateFlags")
    public int flags() {
        return VkEventCreateInfo.nflags(this.address());
    }

    public VkEventCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkEventCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkEventCreateInfo sType$Default() {
        return this.sType(10);
    }

    public VkEventCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkEventCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkEventCreateInfo flags(@NativeType(value="VkEventCreateFlags") int value) {
        VkEventCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkEventCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkEventCreateInfo set(VkEventCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkEventCreateInfo malloc() {
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkEventCreateInfo calloc() {
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkEventCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkEventCreateInfo create(long address) {
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, address);
    }

    @Nullable
    public static VkEventCreateInfo createSafe(long address) {
        return address == 0L ? null : VkEventCreateInfo.wrap(VkEventCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkEventCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkEventCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkEventCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkEventCreateInfo.__create(capacity, SIZEOF);
        return VkEventCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkEventCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkEventCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack() {
        return VkEventCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo callocStack() {
        return VkEventCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack(MemoryStack stack) {
        return VkEventCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkEventCreateInfo callocStack(MemoryStack stack) {
        return VkEventCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkEventCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkEventCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.calloc(capacity, stack);
    }

    public static VkEventCreateInfo malloc(MemoryStack stack) {
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkEventCreateInfo calloc(MemoryStack stack) {
        return VkEventCreateInfo.wrap(VkEventCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkEventCreateInfo.__struct(VkEventCreateInfo.__member(4), VkEventCreateInfo.__member(POINTER_SIZE), VkEventCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkEventCreateInfo, Buffer>
    implements NativeResource {
        private static final VkEventCreateInfo ELEMENT_FACTORY = VkEventCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkEventCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkEventCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkEventCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkEventCreateFlags")
        public int flags() {
            return VkEventCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkEventCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(10);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkEventCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkEventCreateFlags") int value) {
            VkEventCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

