/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    public VkFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFormatProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int linearTilingFeatures() {
        return VkFormatProperties.nlinearTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int optimalTilingFeatures() {
        return VkFormatProperties.noptimalTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int bufferFeatures() {
        return VkFormatProperties.nbufferFeatures(this.address());
    }

    public static VkFormatProperties malloc() {
        return VkFormatProperties.wrap(VkFormatProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkFormatProperties calloc() {
        return VkFormatProperties.wrap(VkFormatProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkFormatProperties.wrap(VkFormatProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static VkFormatProperties create(long address) {
        return VkFormatProperties.wrap(VkFormatProperties.class, address);
    }

    @Nullable
    public static VkFormatProperties createSafe(long address) {
        return address == 0L ? null : VkFormatProperties.wrap(VkFormatProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkFormatProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkFormatProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFormatProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFormatProperties.__create(capacity, SIZEOF);
        return VkFormatProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkFormatProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkFormatProperties.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkFormatProperties mallocStack() {
        return VkFormatProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFormatProperties callocStack() {
        return VkFormatProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFormatProperties mallocStack(MemoryStack stack) {
        return VkFormatProperties.malloc(stack);
    }

    @Deprecated
    public static VkFormatProperties callocStack(MemoryStack stack) {
        return VkFormatProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkFormatProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkFormatProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.calloc(capacity, stack);
    }

    public static VkFormatProperties malloc(MemoryStack stack) {
        return VkFormatProperties.wrap(VkFormatProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFormatProperties calloc(MemoryStack stack) {
        return VkFormatProperties.wrap(VkFormatProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkFormatProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkFormatProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlinearTilingFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINEARTILINGFEATURES);
    }

    public static int noptimalTilingFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)OPTIMALTILINGFEATURES);
    }

    public static int nbufferFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERFEATURES);
    }

    static {
        Struct.Layout layout = VkFormatProperties.__struct(VkFormatProperties.__member(4), VkFormatProperties.__member(4), VkFormatProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LINEARTILINGFEATURES = layout.offsetof(0);
        OPTIMALTILINGFEATURES = layout.offsetof(1);
        BUFFERFEATURES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties, Buffer>
    implements NativeResource {
        private static final VkFormatProperties ELEMENT_FACTORY = VkFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int linearTilingFeatures() {
            return VkFormatProperties.nlinearTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int optimalTilingFeatures() {
            return VkFormatProperties.noptimalTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int bufferFeatures() {
            return VkFormatProperties.nbufferFeatures(this.address());
        }
    }
}

