/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDedicatedAllocationImageCreateInfoNV;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfoKHR;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfoNV;
import org.lwjgl.vulkan.VkImageDrmFormatModifierExplicitCreateInfoEXT;
import org.lwjgl.vulkan.VkImageDrmFormatModifierListCreateInfoEXT;
import org.lwjgl.vulkan.VkImageFormatListCreateInfo;
import org.lwjgl.vulkan.VkImageFormatListCreateInfoKHR;
import org.lwjgl.vulkan.VkImageStencilUsageCreateInfo;
import org.lwjgl.vulkan.VkImageStencilUsageCreateInfoEXT;
import org.lwjgl.vulkan.VkImageSwapchainCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoDecodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoProfileKHR;
import org.lwjgl.vulkan.VkVideoProfilesKHR;

public class VkImageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int IMAGETYPE;
    public static final int FORMAT;
    public static final int EXTENT;
    public static final int MIPLEVELS;
    public static final int ARRAYLAYERS;
    public static final int SAMPLES;
    public static final int TILING;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int INITIALLAYOUT;

    public VkImageCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkImageCreateFlags")
    public int flags() {
        return VkImageCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkImageType")
    public int imageType() {
        return VkImageCreateInfo.nimageType(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkImageCreateInfo.nformat(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCreateInfo.nextent(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipLevels() {
        return VkImageCreateInfo.nmipLevels(this.address());
    }

    @NativeType(value="uint32_t")
    public int arrayLayers() {
        return VkImageCreateInfo.narrayLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int samples() {
        return VkImageCreateInfo.nsamples(this.address());
    }

    @NativeType(value="VkImageTiling")
    public int tiling() {
        return VkImageCreateInfo.ntiling(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int usage() {
        return VkImageCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int sharingMode() {
        return VkImageCreateInfo.nsharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pQueueFamilyIndices() {
        return VkImageCreateInfo.npQueueFamilyIndices(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int initialLayout() {
        return VkImageCreateInfo.ninitialLayout(this.address());
    }

    public VkImageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo sType$Default() {
        return this.sType(14);
    }

    public VkImageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkImageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pNext(VkDedicatedAllocationImageCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkExternalMemoryImageCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkExternalMemoryImageCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkExternalMemoryImageCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageDrmFormatModifierExplicitCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageDrmFormatModifierListCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageFormatListCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageFormatListCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageStencilUsageCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageStencilUsageCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkImageSwapchainCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoDecodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoDecodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoEncodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoEncodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoProfileKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo pNext(VkVideoProfilesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageCreateInfo flags(@NativeType(value="VkImageCreateFlags") int value) {
        VkImageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkImageCreateInfo imageType(@NativeType(value="VkImageType") int value) {
        VkImageCreateInfo.nimageType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo format(@NativeType(value="VkFormat") int value) {
        VkImageCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkImageCreateInfo extent(VkExtent3D value) {
        VkImageCreateInfo.nextent(this.address(), value);
        return this;
    }

    public VkImageCreateInfo extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkImageCreateInfo mipLevels(@NativeType(value="uint32_t") int value) {
        VkImageCreateInfo.nmipLevels(this.address(), value);
        return this;
    }

    public VkImageCreateInfo arrayLayers(@NativeType(value="uint32_t") int value) {
        VkImageCreateInfo.narrayLayers(this.address(), value);
        return this;
    }

    public VkImageCreateInfo samples(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkImageCreateInfo.nsamples(this.address(), value);
        return this;
    }

    public VkImageCreateInfo tiling(@NativeType(value="VkImageTiling") int value) {
        VkImageCreateInfo.ntiling(this.address(), value);
        return this;
    }

    public VkImageCreateInfo usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkImageCreateInfo sharingMode(@NativeType(value="VkSharingMode") int value) {
        VkImageCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkImageCreateInfo queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
        VkImageCreateInfo.nqueueFamilyIndexCount(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkImageCreateInfo initialLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageCreateInfo.ninitialLayout(this.address(), value);
        return this;
    }

    public VkImageCreateInfo set(int sType, long pNext, int flags, int imageType, int format, VkExtent3D extent, int mipLevels, int arrayLayers, int samples, int tiling, int usage, int sharingMode, int queueFamilyIndexCount, @Nullable IntBuffer pQueueFamilyIndices, int initialLayout) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.imageType(imageType);
        this.format(format);
        this.extent(extent);
        this.mipLevels(mipLevels);
        this.arrayLayers(arrayLayers);
        this.samples(samples);
        this.tiling(tiling);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.queueFamilyIndexCount(queueFamilyIndexCount);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.initialLayout(initialLayout);
        return this;
    }

    public VkImageCreateInfo set(VkImageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCreateInfo malloc() {
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageCreateInfo calloc() {
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImageCreateInfo create(long address) {
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, address);
    }

    @Nullable
    public static VkImageCreateInfo createSafe(long address) {
        return address == 0L ? null : VkImageCreateInfo.wrap(VkImageCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImageCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCreateInfo.__create(capacity, SIZEOF);
        return VkImageCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImageCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImageCreateInfo mallocStack() {
        return VkImageCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageCreateInfo callocStack() {
        return VkImageCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageCreateInfo mallocStack(MemoryStack stack) {
        return VkImageCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkImageCreateInfo callocStack(MemoryStack stack) {
        return VkImageCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.calloc(capacity, stack);
    }

    public static VkImageCreateInfo malloc(MemoryStack stack) {
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageCreateInfo calloc(MemoryStack stack) {
        return VkImageCreateInfo.wrap(VkImageCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nimageType(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGETYPE);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static int nmipLevels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPLEVELS);
    }

    public static int narrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARRAYLAYERS);
    }

    public static int nsamples(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLES);
    }

    public static int ntiling(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILING);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES), VkImageCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static int ninitialLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)INITIALLAYOUT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nimageType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGETYPE, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    public static void nmipLevels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPLEVELS, value);
    }

    public static void narrayLayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARRAYLAYERS, value);
    }

    public static void nsamples(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLES, value);
    }

    public static void ntiling(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILING, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEFAMILYINDICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkImageCreateInfo.nqueueFamilyIndexCount(struct, value.remaining());
        }
    }

    public static void ninitialLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INITIALLAYOUT, value);
    }

    static {
        Struct.Layout layout = VkImageCreateInfo.__struct(VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(POINTER_SIZE), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(POINTER_SIZE), VkImageCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        IMAGETYPE = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        EXTENT = layout.offsetof(5);
        MIPLEVELS = layout.offsetof(6);
        ARRAYLAYERS = layout.offsetof(7);
        SAMPLES = layout.offsetof(8);
        TILING = layout.offsetof(9);
        USAGE = layout.offsetof(10);
        SHARINGMODE = layout.offsetof(11);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(12);
        PQUEUEFAMILYINDICES = layout.offsetof(13);
        INITIALLAYOUT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<VkImageCreateInfo, Buffer>
    implements NativeResource {
        private static final VkImageCreateInfo ELEMENT_FACTORY = VkImageCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkImageCreateFlags")
        public int flags() {
            return VkImageCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkImageType")
        public int imageType() {
            return VkImageCreateInfo.nimageType(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkImageCreateInfo.nformat(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCreateInfo.nextent(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipLevels() {
            return VkImageCreateInfo.nmipLevels(this.address());
        }

        @NativeType(value="uint32_t")
        public int arrayLayers() {
            return VkImageCreateInfo.narrayLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int samples() {
            return VkImageCreateInfo.nsamples(this.address());
        }

        @NativeType(value="VkImageTiling")
        public int tiling() {
            return VkImageCreateInfo.ntiling(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int usage() {
            return VkImageCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int sharingMode() {
            return VkImageCreateInfo.nsharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pQueueFamilyIndices() {
            return VkImageCreateInfo.npQueueFamilyIndices(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int initialLayout() {
            return VkImageCreateInfo.ninitialLayout(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(14);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDedicatedAllocationImageCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalMemoryImageCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalMemoryImageCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalMemoryImageCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageDrmFormatModifierExplicitCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageDrmFormatModifierListCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageFormatListCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageFormatListCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageStencilUsageCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageStencilUsageCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageSwapchainCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoProfileKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoProfilesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkImageCreateFlags") int value) {
            VkImageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer imageType(@NativeType(value="VkImageType") int value) {
            VkImageCreateInfo.nimageType(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkImageCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCreateInfo.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer mipLevels(@NativeType(value="uint32_t") int value) {
            VkImageCreateInfo.nmipLevels(this.address(), value);
            return this;
        }

        public Buffer arrayLayers(@NativeType(value="uint32_t") int value) {
            VkImageCreateInfo.narrayLayers(this.address(), value);
            return this;
        }

        public Buffer samples(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkImageCreateInfo.nsamples(this.address(), value);
            return this;
        }

        public Buffer tiling(@NativeType(value="VkImageTiling") int value) {
            VkImageCreateInfo.ntiling(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(@NativeType(value="VkSharingMode") int value) {
            VkImageCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
            VkImageCreateInfo.nqueueFamilyIndexCount(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer initialLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageCreateInfo.ninitialLayout(this.address(), value);
            return this;
        }
    }
}

