/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageViewHandleInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGEVIEW;
    public static final int DESCRIPTORTYPE;
    public static final int SAMPLER;

    public VkImageViewHandleInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageViewHandleInfoNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageViewHandleInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageViewHandleInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkImageView")
    public long imageView() {
        return VkImageViewHandleInfoNVX.nimageView(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkImageViewHandleInfoNVX.ndescriptorType(this.address());
    }

    @NativeType(value="VkSampler")
    public long sampler() {
        return VkImageViewHandleInfoNVX.nsampler(this.address());
    }

    public VkImageViewHandleInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewHandleInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkImageViewHandleInfoNVX sType$Default() {
        return this.sType(1000030000);
    }

    public VkImageViewHandleInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkImageViewHandleInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkImageViewHandleInfoNVX imageView(@NativeType(value="VkImageView") long value) {
        VkImageViewHandleInfoNVX.nimageView(this.address(), value);
        return this;
    }

    public VkImageViewHandleInfoNVX descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkImageViewHandleInfoNVX.ndescriptorType(this.address(), value);
        return this;
    }

    public VkImageViewHandleInfoNVX sampler(@NativeType(value="VkSampler") long value) {
        VkImageViewHandleInfoNVX.nsampler(this.address(), value);
        return this;
    }

    public VkImageViewHandleInfoNVX set(int sType, long pNext, long imageView, int descriptorType, long sampler) {
        this.sType(sType);
        this.pNext(pNext);
        this.imageView(imageView);
        this.descriptorType(descriptorType);
        this.sampler(sampler);
        return this;
    }

    public VkImageViewHandleInfoNVX set(VkImageViewHandleInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageViewHandleInfoNVX malloc() {
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageViewHandleInfoNVX calloc() {
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageViewHandleInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImageViewHandleInfoNVX create(long address) {
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, address);
    }

    @Nullable
    public static VkImageViewHandleInfoNVX createSafe(long address) {
        return address == 0L ? null : VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImageViewHandleInfoNVX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageViewHandleInfoNVX.__create(capacity, SIZEOF);
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageViewHandleInfoNVX.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImageViewHandleInfoNVX mallocStack() {
        return VkImageViewHandleInfoNVX.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewHandleInfoNVX callocStack() {
        return VkImageViewHandleInfoNVX.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewHandleInfoNVX mallocStack(MemoryStack stack) {
        return VkImageViewHandleInfoNVX.malloc(stack);
    }

    @Deprecated
    public static VkImageViewHandleInfoNVX callocStack(MemoryStack stack) {
        return VkImageViewHandleInfoNVX.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageViewHandleInfoNVX.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageViewHandleInfoNVX.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewHandleInfoNVX.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewHandleInfoNVX.calloc(capacity, stack);
    }

    public static VkImageViewHandleInfoNVX malloc(MemoryStack stack) {
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageViewHandleInfoNVX calloc(MemoryStack stack) {
        return VkImageViewHandleInfoNVX.wrap(VkImageViewHandleInfoNVX.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImageViewHandleInfoNVX.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimageView(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEVIEW);
    }

    public static int ndescriptorType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORTYPE);
    }

    public static long nsampler(long struct) {
        return UNSAFE.getLong(null, struct + (long)SAMPLER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimageView(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGEVIEW, value);
    }

    public static void ndescriptorType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORTYPE, value);
    }

    public static void nsampler(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SAMPLER, value);
    }

    static {
        Struct.Layout layout = VkImageViewHandleInfoNVX.__struct(VkImageViewHandleInfoNVX.__member(4), VkImageViewHandleInfoNVX.__member(POINTER_SIZE), VkImageViewHandleInfoNVX.__member(8), VkImageViewHandleInfoNVX.__member(4), VkImageViewHandleInfoNVX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGEVIEW = layout.offsetof(2);
        DESCRIPTORTYPE = layout.offsetof(3);
        SAMPLER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageViewHandleInfoNVX, Buffer>
    implements NativeResource {
        private static final VkImageViewHandleInfoNVX ELEMENT_FACTORY = VkImageViewHandleInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageViewHandleInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageViewHandleInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageViewHandleInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkImageView")
        public long imageView() {
            return VkImageViewHandleInfoNVX.nimageView(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkImageViewHandleInfoNVX.ndescriptorType(this.address());
        }

        @NativeType(value="VkSampler")
        public long sampler() {
            return VkImageViewHandleInfoNVX.nsampler(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewHandleInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000030000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewHandleInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkImageViewHandleInfoNVX.nimageView(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkImageViewHandleInfoNVX.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer sampler(@NativeType(value="VkSampler") long value) {
            VkImageViewHandleInfoNVX.nsampler(this.address(), value);
            return this;
        }
    }
}

