/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportFenceWin32HandleInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FENCE;
    public static final int FLAGS;
    public static final int HANDLETYPE;
    public static final int HANDLE;
    public static final int NAME;

    public VkImportFenceWin32HandleInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImportFenceWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportFenceWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportFenceWin32HandleInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkFence")
    public long fence() {
        return VkImportFenceWin32HandleInfoKHR.nfence(this.address());
    }

    @NativeType(value="VkFenceImportFlags")
    public int flags() {
        return VkImportFenceWin32HandleInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlagBits")
    public int handleType() {
        return VkImportFenceWin32HandleInfoKHR.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportFenceWin32HandleInfoKHR.nhandle(this.address());
    }

    @NativeType(value="LPCWSTR")
    public ByteBuffer name() {
        return VkImportFenceWin32HandleInfoKHR.nname(this.address());
    }

    @NativeType(value="LPCWSTR")
    public String nameString() {
        return VkImportFenceWin32HandleInfoKHR.nnameString(this.address());
    }

    public VkImportFenceWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImportFenceWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR sType$Default() {
        return this.sType(1000114000);
    }

    public VkImportFenceWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImportFenceWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR fence(@NativeType(value="VkFence") long value) {
        VkImportFenceWin32HandleInfoKHR.nfence(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR flags(@NativeType(value="VkFenceImportFlags") int value) {
        VkImportFenceWin32HandleInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
        VkImportFenceWin32HandleInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR handle(@NativeType(value="HANDLE") long value) {
        VkImportFenceWin32HandleInfoKHR.nhandle(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR name(@NativeType(value="LPCWSTR") ByteBuffer value) {
        VkImportFenceWin32HandleInfoKHR.nname(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR set(int sType, long pNext, long fence, int flags, int handleType, long handle, ByteBuffer name) {
        this.sType(sType);
        this.pNext(pNext);
        this.fence(fence);
        this.flags(flags);
        this.handleType(handleType);
        this.handle(handle);
        this.name(name);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR set(VkImportFenceWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportFenceWin32HandleInfoKHR malloc() {
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR calloc() {
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImportFenceWin32HandleInfoKHR create(long address) {
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, address);
    }

    @Nullable
    public static VkImportFenceWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImportFenceWin32HandleInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportFenceWin32HandleInfoKHR.__create(capacity, SIZEOF);
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImportFenceWin32HandleInfoKHR mallocStack() {
        return VkImportFenceWin32HandleInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportFenceWin32HandleInfoKHR callocStack() {
        return VkImportFenceWin32HandleInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportFenceWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkImportFenceWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.calloc(capacity, stack);
    }

    public static VkImportFenceWin32HandleInfoKHR malloc(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR calloc(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.wrap(VkImportFenceWin32HandleInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nfence(long struct) {
        return UNSAFE.getLong(null, struct + (long)FENCE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nfence(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FENCE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = VkImportFenceWin32HandleInfoKHR.__struct(VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportFenceWin32HandleInfoKHR.__member(8), VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FENCE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        HANDLETYPE = layout.offsetof(4);
        HANDLE = layout.offsetof(5);
        NAME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkImportFenceWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        private static final VkImportFenceWin32HandleInfoKHR ELEMENT_FACTORY = VkImportFenceWin32HandleInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImportFenceWin32HandleInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportFenceWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportFenceWin32HandleInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkFence")
        public long fence() {
            return VkImportFenceWin32HandleInfoKHR.nfence(this.address());
        }

        @NativeType(value="VkFenceImportFlags")
        public int flags() {
            return VkImportFenceWin32HandleInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlagBits")
        public int handleType() {
            return VkImportFenceWin32HandleInfoKHR.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportFenceWin32HandleInfoKHR.nhandle(this.address());
        }

        @NativeType(value="LPCWSTR")
        public ByteBuffer name() {
            return VkImportFenceWin32HandleInfoKHR.nname(this.address());
        }

        @NativeType(value="LPCWSTR")
        public String nameString() {
            return VkImportFenceWin32HandleInfoKHR.nnameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportFenceWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000114000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportFenceWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer fence(@NativeType(value="VkFence") long value) {
            VkImportFenceWin32HandleInfoKHR.nfence(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkFenceImportFlags") int value) {
            VkImportFenceWin32HandleInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
            VkImportFenceWin32HandleInfoKHR.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportFenceWin32HandleInfoKHR.nhandle(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="LPCWSTR") ByteBuffer value) {
            VkImportFenceWin32HandleInfoKHR.nname(this.address(), value);
            return this;
        }
    }
}

