/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutTokenNV;

public class VkIndirectCommandsLayoutCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int TOKENCOUNT;
    public static final int PTOKENS;
    public static final int STREAMCOUNT;
    public static final int PSTREAMSTRIDES;

    public VkIndirectCommandsLayoutCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkIndirectCommandsLayoutCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV")
    public int flags() {
        return VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int tokenCount() {
        return VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutTokenNV const *")
    public VkIndirectCommandsLayoutTokenNV.Buffer pTokens() {
        return VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address());
    }

    @NativeType(value="uint32_t")
    public int streamCount() {
        return VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pStreamStrides() {
        return VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address());
    }

    public VkIndirectCommandsLayoutCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV sType$Default() {
        return this.sType(1000277004);
    }

    public VkIndirectCommandsLayoutCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNV const *") VkIndirectCommandsLayoutTokenNV.Buffer value) {
        VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pStreamStrides(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV set(int sType, long pNext, int flags, int pipelineBindPoint, VkIndirectCommandsLayoutTokenNV.Buffer pTokens, IntBuffer pStreamStrides) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pTokens(pTokens);
        this.pStreamStrides(pStreamStrides);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV set(VkIndirectCommandsLayoutCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutCreateInfoNV malloc() {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNV calloc() {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV create(long address) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, address);
    }

    @Nullable
    public static VkIndirectCommandsLayoutCreateInfoNV createSafe(long address) {
        return address == 0L ? null : VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkIndirectCommandsLayoutCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsLayoutCreateInfoNV.__create(capacity, SIZEOF);
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV malloc(MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNV calloc(MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(VkIndirectCommandsLayoutCreateInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static int ntokenCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOKENCOUNT);
    }

    public static VkIndirectCommandsLayoutTokenNV.Buffer npTokens(long struct) {
        return VkIndirectCommandsLayoutTokenNV.create(MemoryUtil.memGetAddress(struct + (long)PTOKENS), VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct));
    }

    public static int nstreamCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STREAMCOUNT);
    }

    public static IntBuffer npStreamStrides(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PSTREAMSTRIDES), VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void ntokenCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TOKENCOUNT, value);
    }

    public static void npTokens(long struct, VkIndirectCommandsLayoutTokenNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTOKENS, value.address());
        VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct, value.remaining());
    }

    public static void nstreamCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STREAMCOUNT, value);
    }

    public static void npStreamStrides(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTREAMSTRIDES, MemoryUtil.memAddress(value));
        VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int tokenCount = VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct);
        long pTokens = MemoryUtil.memGetAddress(struct + (long)PTOKENS);
        Checks.check(pTokens);
        VkIndirectCommandsLayoutCreateInfoNV.validate(pTokens, tokenCount, VkIndirectCommandsLayoutTokenNV.SIZEOF, VkIndirectCommandsLayoutTokenNV::validate);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSTREAMSTRIDES));
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutCreateInfoNV.__struct(VkIndirectCommandsLayoutCreateInfoNV.__member(4), VkIndirectCommandsLayoutCreateInfoNV.__member(POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNV.__member(4), VkIndirectCommandsLayoutCreateInfoNV.__member(4), VkIndirectCommandsLayoutCreateInfoNV.__member(4), VkIndirectCommandsLayoutCreateInfoNV.__member(POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNV.__member(4), VkIndirectCommandsLayoutCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PIPELINEBINDPOINT = layout.offsetof(3);
        TOKENCOUNT = layout.offsetof(4);
        PTOKENS = layout.offsetof(5);
        STREAMCOUNT = layout.offsetof(6);
        PSTREAMSTRIDES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsLayoutCreateInfoNV ELEMENT_FACTORY = VkIndirectCommandsLayoutCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkIndirectCommandsLayoutCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV")
        public int flags() {
            return VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int tokenCount() {
            return VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutTokenNV const *")
        public VkIndirectCommandsLayoutTokenNV.Buffer pTokens() {
            return VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address());
        }

        @NativeType(value="uint32_t")
        public int streamCount() {
            return VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pStreamStrides() {
            return VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNV const *") VkIndirectCommandsLayoutTokenNV.Buffer value) {
            VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address(), value);
            return this;
        }

        public Buffer pStreamStrides(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address(), value);
            return this;
        }
    }
}

