/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHostPointerPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    public VkMemoryHostPointerPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryHostPointerPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
    }

    public VkMemoryHostPointerPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT sType$Default() {
        return this.sType(1000178001);
    }

    public VkMemoryHostPointerPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(VkMemoryHostPointerPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryHostPointerPropertiesEXT malloc() {
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT calloc() {
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryHostPointerPropertiesEXT create(long address) {
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, address);
    }

    @Nullable
    public static VkMemoryHostPointerPropertiesEXT createSafe(long address) {
        return address == 0L ? null : VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryHostPointerPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryHostPointerPropertiesEXT.__create(capacity, SIZEOF);
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT mallocStack() {
        return VkMemoryHostPointerPropertiesEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT callocStack() {
        return VkMemoryHostPointerPropertiesEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT mallocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.malloc(stack);
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT callocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.calloc(capacity, stack);
    }

    public static VkMemoryHostPointerPropertiesEXT malloc(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT calloc(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMemoryHostPointerPropertiesEXT.__struct(VkMemoryHostPointerPropertiesEXT.__member(4), VkMemoryHostPointerPropertiesEXT.__member(POINTER_SIZE), VkMemoryHostPointerPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHostPointerPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryHostPointerPropertiesEXT ELEMENT_FACTORY = VkMemoryHostPointerPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryHostPointerPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000178001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

