/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfo;

public class VkMemoryOpaqueCaptureAddressAllocateInfoKHR
extends VkMemoryOpaqueCaptureAddressAllocateInfo {
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR sType$Default() {
        return this.sType(1000257003);
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR set(VkMemoryOpaqueCaptureAddressAllocateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR malloc() {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR calloc() {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR create(long address) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, address);
    }

    @Nullable
    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryOpaqueCaptureAddressAllocateInfoKHR.__create(capacity, SIZEOF);
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR malloc(MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR calloc(MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(VkMemoryOpaqueCaptureAddressAllocateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryOpaqueCaptureAddressAllocateInfo.Buffer {
        private static final VkMemoryOpaqueCaptureAddressAllocateInfoKHR ELEMENT_FACTORY = VkMemoryOpaqueCaptureAddressAllocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryOpaqueCaptureAddressAllocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000257003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

