/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int MEMORYTYPEBITS;

    public VkMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryRequirements.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VkMemoryRequirements.nalignment(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryRequirements.nmemoryTypeBits(this.address());
    }

    public static VkMemoryRequirements malloc() {
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryRequirements calloc() {
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryRequirements create(long address) {
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, address);
    }

    @Nullable
    public static VkMemoryRequirements createSafe(long address) {
        return address == 0L ? null : VkMemoryRequirements.wrap(VkMemoryRequirements.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryRequirements.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements.__create(capacity, SIZEOF);
        return VkMemoryRequirements.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack() {
        return VkMemoryRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements callocStack() {
        return VkMemoryRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack(MemoryStack stack) {
        return VkMemoryRequirements.malloc(stack);
    }

    @Deprecated
    public static VkMemoryRequirements callocStack(MemoryStack stack) {
        return VkMemoryRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.calloc(capacity, stack);
    }

    public static VkMemoryRequirements malloc(MemoryStack stack) {
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryRequirements calloc(MemoryStack stack) {
        return VkMemoryRequirements.wrap(VkMemoryRequirements.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALIGNMENT);
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements.__struct(VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryRequirements ELEMENT_FACTORY = VkMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryRequirements.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VkMemoryRequirements.nalignment(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryRequirements.nmemoryTypeBits(this.address());
        }
    }
}

