/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryRequirements2;

public class VkMemoryRequirements2KHR
extends VkMemoryRequirements2 {
    public VkMemoryRequirements2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryRequirements2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryRequirements2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryRequirements2KHR sType$Default() {
        return this.sType(1000146003);
    }

    @Override
    public VkMemoryRequirements2KHR pNext(@NativeType(value="void *") long value) {
        VkMemoryRequirements2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryRequirements2KHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryRequirements2KHR set(VkMemoryRequirements2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryRequirements2KHR malloc() {
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryRequirements2KHR calloc() {
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryRequirements2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryRequirements2KHR create(long address) {
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, address);
    }

    @Nullable
    public static VkMemoryRequirements2KHR createSafe(long address) {
        return address == 0L ? null : VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryRequirements2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryRequirements2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryRequirements2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements2KHR.__create(capacity, SIZEOF);
        return VkMemoryRequirements2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryRequirements2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryRequirements2KHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryRequirements2KHR mallocStack() {
        return VkMemoryRequirements2KHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements2KHR callocStack() {
        return VkMemoryRequirements2KHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements2KHR mallocStack(MemoryStack stack) {
        return VkMemoryRequirements2KHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryRequirements2KHR callocStack(MemoryStack stack) {
        return VkMemoryRequirements2KHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements2KHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements2KHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2KHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2KHR.calloc(capacity, stack);
    }

    public static VkMemoryRequirements2KHR malloc(MemoryStack stack) {
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryRequirements2KHR calloc(MemoryStack stack) {
        return VkMemoryRequirements2KHR.wrap(VkMemoryRequirements2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryRequirements2.Buffer {
        private static final VkMemoryRequirements2KHR ELEMENT_FACTORY = VkMemoryRequirements2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryRequirements2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryRequirements2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000146003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryRequirements2KHR.npNext(this.address(), value);
            return this;
        }
    }
}

