/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMetalSurfaceCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PLAYER;

    public VkMetalSurfaceCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMetalSurfaceCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMetalSurfaceCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMetalSurfaceCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkMetalSurfaceCreateFlagsEXT")
    public int flags() {
        return VkMetalSurfaceCreateInfoEXT.nflags(this.address());
    }

    @Nullable
    @NativeType(value="CAMetalLayer const *")
    public PointerBuffer pLayer(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), capacity);
    }

    public VkMetalSurfaceCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMetalSurfaceCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT sType$Default() {
        return this.sType(1000217000);
    }

    public VkMetalSurfaceCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMetalSurfaceCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT flags(@NativeType(value="VkMetalSurfaceCreateFlagsEXT") int value) {
        VkMetalSurfaceCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT pLayer(@Nullable @NativeType(value="CAMetalLayer const *") PointerBuffer value) {
        VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT set(int sType, long pNext, int flags, @Nullable PointerBuffer pLayer) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pLayer(pLayer);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT set(VkMetalSurfaceCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMetalSurfaceCreateInfoEXT malloc() {
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT calloc() {
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMetalSurfaceCreateInfoEXT create(long address) {
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, address);
    }

    @Nullable
    public static VkMetalSurfaceCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMetalSurfaceCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMetalSurfaceCreateInfoEXT.__create(capacity, SIZEOF);
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMetalSurfaceCreateInfoEXT mallocStack() {
        return VkMetalSurfaceCreateInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMetalSurfaceCreateInfoEXT callocStack() {
        return VkMetalSurfaceCreateInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMetalSurfaceCreateInfoEXT mallocStack(MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkMetalSurfaceCreateInfoEXT callocStack(MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.calloc(capacity, stack);
    }

    public static VkMetalSurfaceCreateInfoEXT malloc(MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT calloc(MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static PointerBuffer npLayer(long struct, int capacity) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PLAYER), capacity);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npLayer(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PLAYER, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkMetalSurfaceCreateInfoEXT.__struct(VkMetalSurfaceCreateInfoEXT.__member(4), VkMetalSurfaceCreateInfoEXT.__member(POINTER_SIZE), VkMetalSurfaceCreateInfoEXT.__member(4), VkMetalSurfaceCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PLAYER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMetalSurfaceCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMetalSurfaceCreateInfoEXT ELEMENT_FACTORY = VkMetalSurfaceCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMetalSurfaceCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMetalSurfaceCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMetalSurfaceCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkMetalSurfaceCreateFlagsEXT")
        public int flags() {
            return VkMetalSurfaceCreateInfoEXT.nflags(this.address());
        }

        @Nullable
        @NativeType(value="CAMetalLayer const *")
        public PointerBuffer pLayer(int capacity) {
            return VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMetalSurfaceCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000217000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMetalSurfaceCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMetalSurfaceCreateFlagsEXT") int value) {
            VkMetalSurfaceCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer pLayer(@Nullable @NativeType(value="CAMetalLayer const *") PointerBuffer value) {
            VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), value);
            return this;
        }
    }
}

