/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkConformanceVersion;

public class VkPhysicalDeviceDriverProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DRIVERID;
    public static final int DRIVERNAME;
    public static final int DRIVERINFO;
    public static final int CONFORMANCEVERSION;

    public VkPhysicalDeviceDriverProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceDriverProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceDriverProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceDriverProperties.npNext(this.address());
    }

    @NativeType(value="VkDriverId")
    public int driverID() {
        return VkPhysicalDeviceDriverProperties.ndriverID(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public ByteBuffer driverName() {
        return VkPhysicalDeviceDriverProperties.ndriverName(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public String driverNameString() {
        return VkPhysicalDeviceDriverProperties.ndriverNameString(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public ByteBuffer driverInfo() {
        return VkPhysicalDeviceDriverProperties.ndriverInfo(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public String driverInfoString() {
        return VkPhysicalDeviceDriverProperties.ndriverInfoString(this.address());
    }

    public VkConformanceVersion conformanceVersion() {
        return VkPhysicalDeviceDriverProperties.nconformanceVersion(this.address());
    }

    public VkPhysicalDeviceDriverProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceDriverProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverProperties sType$Default() {
        return this.sType(1000196000);
    }

    public VkPhysicalDeviceDriverProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceDriverProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceDriverProperties set(VkPhysicalDeviceDriverProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceDriverProperties malloc() {
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties calloc() {
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceDriverProperties create(long address) {
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, address);
    }

    @Nullable
    public static VkPhysicalDeviceDriverProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPhysicalDeviceDriverProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceDriverProperties.__create(capacity, SIZEOF);
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceDriverProperties.wrap(Buffer.class, address, capacity);
    }

    public static VkPhysicalDeviceDriverProperties malloc(MemoryStack stack) {
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties calloc(MemoryStack stack) {
        return VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceDriverProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndriverID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERID);
    }

    public static ByteBuffer ndriverName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DRIVERNAME, 256);
    }

    public static String ndriverNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DRIVERNAME);
    }

    public static ByteBuffer ndriverInfo(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DRIVERINFO, 256);
    }

    public static String ndriverInfoString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DRIVERINFO);
    }

    public static VkConformanceVersion nconformanceVersion(long struct) {
        return VkConformanceVersion.create(struct + (long)CONFORMANCEVERSION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceDriverProperties.__struct(VkPhysicalDeviceDriverProperties.__member(4), VkPhysicalDeviceDriverProperties.__member(POINTER_SIZE), VkPhysicalDeviceDriverProperties.__member(4), VkPhysicalDeviceDriverProperties.__array(1, 256), VkPhysicalDeviceDriverProperties.__array(1, 256), VkPhysicalDeviceDriverProperties.__member(VkConformanceVersion.SIZEOF, VkConformanceVersion.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DRIVERID = layout.offsetof(2);
        DRIVERNAME = layout.offsetof(3);
        DRIVERINFO = layout.offsetof(4);
        CONFORMANCEVERSION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceDriverProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceDriverProperties ELEMENT_FACTORY = VkPhysicalDeviceDriverProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceDriverProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceDriverProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceDriverProperties.npNext(this.address());
        }

        @NativeType(value="VkDriverId")
        public int driverID() {
            return VkPhysicalDeviceDriverProperties.ndriverID(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public ByteBuffer driverName() {
            return VkPhysicalDeviceDriverProperties.ndriverName(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public String driverNameString() {
            return VkPhysicalDeviceDriverProperties.ndriverNameString(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public ByteBuffer driverInfo() {
            return VkPhysicalDeviceDriverProperties.ndriverInfo(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public String driverInfoString() {
            return VkPhysicalDeviceDriverProperties.ndriverInfoString(this.address());
        }

        public VkConformanceVersion conformanceVersion() {
            return VkPhysicalDeviceDriverProperties.nconformanceVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceDriverProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000196000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceDriverProperties.npNext(this.address(), value);
            return this;
        }
    }
}

