/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINE;

    public VkPipelineInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkPipelineInfoKHR.npipeline(this.address());
    }

    public VkPipelineInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR sType$Default() {
        return this.sType(1000269001);
    }

    public VkPipelineInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineInfoKHR.npipeline(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR set(int sType, long pNext, long pipeline) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipeline(pipeline);
        return this;
    }

    public VkPipelineInfoKHR set(VkPipelineInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineInfoKHR malloc() {
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineInfoKHR calloc() {
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineInfoKHR create(long address) {
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, address);
    }

    @Nullable
    public static VkPipelineInfoKHR createSafe(long address) {
        return address == 0L ? null : VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineInfoKHR.__create(capacity, SIZEOF);
        return VkPipelineInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPipelineInfoKHR mallocStack() {
        return VkPipelineInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineInfoKHR callocStack() {
        return VkPipelineInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineInfoKHR mallocStack(MemoryStack stack) {
        return VkPipelineInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkPipelineInfoKHR callocStack(MemoryStack stack) {
        return VkPipelineInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.calloc(capacity, stack);
    }

    public static VkPipelineInfoKHR malloc(MemoryStack stack) {
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineInfoKHR calloc(MemoryStack stack) {
        return VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npipeline(long struct) {
        return UNSAFE.getLong(null, struct + (long)PIPELINE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npipeline(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PIPELINE, value);
    }

    static {
        Struct.Layout layout = VkPipelineInfoKHR.__struct(VkPipelineInfoKHR.__member(4), VkPipelineInfoKHR.__member(POINTER_SIZE), VkPipelineInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineInfoKHR ELEMENT_FACTORY = VkPipelineInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkPipelineInfoKHR.npipeline(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000269001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineInfoKHR.npipeline(this.address(), value);
            return this;
        }
    }
}

