/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineRenderingCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWMASK;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTFORMATS;
    public static final int DEPTHATTACHMENTFORMAT;
    public static final int STENCILATTACHMENTFORMAT;

    public VkPipelineRenderingCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineRenderingCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineRenderingCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineRenderingCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkPipelineRenderingCreateInfo.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pColorAttachmentFormats() {
        return VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address());
    }

    @NativeType(value="VkFormat")
    public int depthAttachmentFormat() {
        return VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address());
    }

    @NativeType(value="VkFormat")
    public int stencilAttachmentFormat() {
        return VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address());
    }

    public VkPipelineRenderingCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineRenderingCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo sType$Default() {
        return this.sType(1000044002);
    }

    public VkPipelineRenderingCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineRenderingCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo viewMask(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfo.nviewMask(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo set(int sType, long pNext, int viewMask, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkPipelineRenderingCreateInfo set(VkPipelineRenderingCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineRenderingCreateInfo malloc() {
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineRenderingCreateInfo calloc() {
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineRenderingCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineRenderingCreateInfo create(long address) {
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, address);
    }

    @Nullable
    public static VkPipelineRenderingCreateInfo createSafe(long address) {
        return address == 0L ? null : VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineRenderingCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineRenderingCreateInfo.__create(capacity, SIZEOF);
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineRenderingCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkPipelineRenderingCreateInfo malloc(MemoryStack stack) {
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineRenderingCreateInfo calloc(MemoryStack stack) {
        return VkPipelineRenderingCreateInfo.wrap(VkPipelineRenderingCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineRenderingCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nviewMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWMASK);
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npColorAttachmentFormats(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTFORMATS), VkPipelineRenderingCreateInfo.ncolorAttachmentCount(struct));
    }

    public static int ndepthAttachmentFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHATTACHMENTFORMAT);
    }

    public static int nstencilAttachmentFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)STENCILATTACHMENTFORMAT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nviewMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWMASK, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachmentFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTFORMATS, MemoryUtil.memAddressSafe(value));
        VkPipelineRenderingCreateInfo.ncolorAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndepthAttachmentFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHATTACHMENTFORMAT, value);
    }

    public static void nstencilAttachmentFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STENCILATTACHMENTFORMAT, value);
    }

    public static void validate(long struct) {
        if (VkPipelineRenderingCreateInfo.ncolorAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTFORMATS));
        }
    }

    static {
        Struct.Layout layout = VkPipelineRenderingCreateInfo.__struct(VkPipelineRenderingCreateInfo.__member(4), VkPipelineRenderingCreateInfo.__member(POINTER_SIZE), VkPipelineRenderingCreateInfo.__member(4), VkPipelineRenderingCreateInfo.__member(4), VkPipelineRenderingCreateInfo.__member(POINTER_SIZE), VkPipelineRenderingCreateInfo.__member(4), VkPipelineRenderingCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWMASK = layout.offsetof(2);
        COLORATTACHMENTCOUNT = layout.offsetof(3);
        PCOLORATTACHMENTFORMATS = layout.offsetof(4);
        DEPTHATTACHMENTFORMAT = layout.offsetof(5);
        STENCILATTACHMENTFORMAT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineRenderingCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineRenderingCreateInfo ELEMENT_FACTORY = VkPipelineRenderingCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineRenderingCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineRenderingCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineRenderingCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkPipelineRenderingCreateInfo.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pColorAttachmentFormats() {
            return VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address());
        }

        @NativeType(value="VkFormat")
        public int depthAttachmentFormat() {
            return VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address());
        }

        @NativeType(value="VkFormat")
        public int stencilAttachmentFormat() {
            return VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineRenderingCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000044002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineRenderingCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfo.nviewMask(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

