/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPipelineRenderingCreateInfo;

public class VkPipelineRenderingCreateInfoKHR
extends VkPipelineRenderingCreateInfo {
    public VkPipelineRenderingCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineRenderingCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR sType$Default() {
        return this.sType(1000044002);
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineRenderingCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR viewMask(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfoKHR.nviewMask(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkPipelineRenderingCreateInfoKHR.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfoKHR.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfoKHR.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR set(int sType, long pNext, int viewMask, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkPipelineRenderingCreateInfoKHR set(VkPipelineRenderingCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineRenderingCreateInfoKHR malloc() {
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineRenderingCreateInfoKHR calloc() {
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineRenderingCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineRenderingCreateInfoKHR create(long address) {
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkPipelineRenderingCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineRenderingCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineRenderingCreateInfoKHR.__create(capacity, SIZEOF);
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkPipelineRenderingCreateInfoKHR malloc(MemoryStack stack) {
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineRenderingCreateInfoKHR calloc(MemoryStack stack) {
        return VkPipelineRenderingCreateInfoKHR.wrap(VkPipelineRenderingCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineRenderingCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPipelineRenderingCreateInfo.Buffer {
        private static final VkPipelineRenderingCreateInfoKHR ELEMENT_FACTORY = VkPipelineRenderingCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineRenderingCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineRenderingCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000044002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineRenderingCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfoKHR.nviewMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkPipelineRenderingCreateInfoKHR.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        @Override
        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfoKHR.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        @Override
        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfoKHR.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

