/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPrivateDataSlotCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    public VkPrivateDataSlotCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPrivateDataSlotCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPrivateDataSlotCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPrivateDataSlotCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPrivateDataSlotCreateFlags")
    public int flags() {
        return VkPrivateDataSlotCreateInfo.nflags(this.address());
    }

    public VkPrivateDataSlotCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPrivateDataSlotCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo sType$Default() {
        return this.sType(1000295002);
    }

    public VkPrivateDataSlotCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPrivateDataSlotCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo flags(@NativeType(value="VkPrivateDataSlotCreateFlags") int value) {
        VkPrivateDataSlotCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkPrivateDataSlotCreateInfo set(VkPrivateDataSlotCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPrivateDataSlotCreateInfo malloc() {
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPrivateDataSlotCreateInfo calloc() {
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPrivateDataSlotCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPrivateDataSlotCreateInfo create(long address) {
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, address);
    }

    @Nullable
    public static VkPrivateDataSlotCreateInfo createSafe(long address) {
        return address == 0L ? null : VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPrivateDataSlotCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPrivateDataSlotCreateInfo.__create(capacity, SIZEOF);
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPrivateDataSlotCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkPrivateDataSlotCreateInfo malloc(MemoryStack stack) {
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPrivateDataSlotCreateInfo calloc(MemoryStack stack) {
        return VkPrivateDataSlotCreateInfo.wrap(VkPrivateDataSlotCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPrivateDataSlotCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkPrivateDataSlotCreateInfo.__struct(VkPrivateDataSlotCreateInfo.__member(4), VkPrivateDataSlotCreateInfo.__member(POINTER_SIZE), VkPrivateDataSlotCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPrivateDataSlotCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPrivateDataSlotCreateInfo ELEMENT_FACTORY = VkPrivateDataSlotCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPrivateDataSlotCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPrivateDataSlotCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPrivateDataSlotCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPrivateDataSlotCreateFlags")
        public int flags() {
            return VkPrivateDataSlotCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPrivateDataSlotCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000295002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPrivateDataSlotCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPrivateDataSlotCreateFlags") int value) {
            VkPrivateDataSlotCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

