/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSampleLocationEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public VkSampleLocationEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSampleLocationEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkSampleLocationEXT.nx(this.address());
    }

    public float y() {
        return VkSampleLocationEXT.ny(this.address());
    }

    public VkSampleLocationEXT x(float value) {
        VkSampleLocationEXT.nx(this.address(), value);
        return this;
    }

    public VkSampleLocationEXT y(float value) {
        VkSampleLocationEXT.ny(this.address(), value);
        return this;
    }

    public VkSampleLocationEXT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkSampleLocationEXT set(VkSampleLocationEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSampleLocationEXT malloc() {
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSampleLocationEXT calloc() {
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSampleLocationEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSampleLocationEXT create(long address) {
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, address);
    }

    @Nullable
    public static VkSampleLocationEXT createSafe(long address) {
        return address == 0L ? null : VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSampleLocationEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSampleLocationEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSampleLocationEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSampleLocationEXT.__create(capacity, SIZEOF);
        return VkSampleLocationEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSampleLocationEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSampleLocationEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSampleLocationEXT mallocStack() {
        return VkSampleLocationEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSampleLocationEXT callocStack() {
        return VkSampleLocationEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSampleLocationEXT mallocStack(MemoryStack stack) {
        return VkSampleLocationEXT.malloc(stack);
    }

    @Deprecated
    public static VkSampleLocationEXT callocStack(MemoryStack stack) {
        return VkSampleLocationEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSampleLocationEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSampleLocationEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.calloc(capacity, stack);
    }

    public static VkSampleLocationEXT malloc(MemoryStack stack) {
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSampleLocationEXT calloc(MemoryStack stack) {
        return VkSampleLocationEXT.wrap(VkSampleLocationEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkSampleLocationEXT.__struct(VkSampleLocationEXT.__member(4), VkSampleLocationEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSampleLocationEXT, Buffer>
    implements NativeResource {
        private static final VkSampleLocationEXT ELEMENT_FACTORY = VkSampleLocationEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSampleLocationEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return VkSampleLocationEXT.nx(this.address());
        }

        public float y() {
            return VkSampleLocationEXT.ny(this.address());
        }

        public Buffer x(float value) {
            VkSampleLocationEXT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkSampleLocationEXT.ny(this.address(), value);
            return this;
        }
    }
}

