/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkSampleLocationEXT;

public class VkSampleLocationsInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SAMPLELOCATIONSPERPIXEL;
    public static final int SAMPLELOCATIONGRIDSIZE;
    public static final int SAMPLELOCATIONSCOUNT;
    public static final int PSAMPLELOCATIONS;

    public VkSampleLocationsInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSampleLocationsInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSampleLocationsInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSampleLocationsInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int sampleLocationsPerPixel() {
        return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
    }

    public VkExtent2D sampleLocationGridSize() {
        return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleLocationsCount() {
        return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSampleLocationEXT const *")
    public VkSampleLocationEXT.Buffer pSampleLocations() {
        return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
    }

    public VkSampleLocationsInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkSampleLocationsInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sType$Default() {
        return this.sType(1000143000);
    }

    public VkSampleLocationsInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkSampleLocationsInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(VkExtent2D value) {
        VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.sampleLocationGridSize());
        return this;
    }

    public VkSampleLocationsInfoEXT pSampleLocations(@Nullable @NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
        VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT set(int sType, long pNext, int sampleLocationsPerPixel, VkExtent2D sampleLocationGridSize, @Nullable VkSampleLocationEXT.Buffer pSampleLocations) {
        this.sType(sType);
        this.pNext(pNext);
        this.sampleLocationsPerPixel(sampleLocationsPerPixel);
        this.sampleLocationGridSize(sampleLocationGridSize);
        this.pSampleLocations(pSampleLocations);
        return this;
    }

    public VkSampleLocationsInfoEXT set(VkSampleLocationsInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSampleLocationsInfoEXT malloc() {
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSampleLocationsInfoEXT calloc() {
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSampleLocationsInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSampleLocationsInfoEXT create(long address) {
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, address);
    }

    @Nullable
    public static VkSampleLocationsInfoEXT createSafe(long address) {
        return address == 0L ? null : VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSampleLocationsInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSampleLocationsInfoEXT.__create(capacity, SIZEOF);
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSampleLocationsInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSampleLocationsInfoEXT mallocStack() {
        return VkSampleLocationsInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSampleLocationsInfoEXT callocStack() {
        return VkSampleLocationsInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSampleLocationsInfoEXT mallocStack(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkSampleLocationsInfoEXT callocStack(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSampleLocationsInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSampleLocationsInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.calloc(capacity, stack);
    }

    public static VkSampleLocationsInfoEXT malloc(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSampleLocationsInfoEXT calloc(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsampleLocationsPerPixel(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLELOCATIONSPERPIXEL);
    }

    public static VkExtent2D nsampleLocationGridSize(long struct) {
        return VkExtent2D.create(struct + (long)SAMPLELOCATIONGRIDSIZE);
    }

    public static int nsampleLocationsCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLELOCATIONSCOUNT);
    }

    @Nullable
    public static VkSampleLocationEXT.Buffer npSampleLocations(long struct) {
        return VkSampleLocationEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS), VkSampleLocationsInfoEXT.nsampleLocationsCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsampleLocationsPerPixel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLELOCATIONSPERPIXEL, value);
    }

    public static void nsampleLocationGridSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SAMPLELOCATIONGRIDSIZE, VkExtent2D.SIZEOF);
    }

    public static void nsampleLocationsCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLELOCATIONSCOUNT, value);
    }

    public static void npSampleLocations(long struct, @Nullable VkSampleLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSAMPLELOCATIONS, MemoryUtil.memAddressSafe(value));
        VkSampleLocationsInfoEXT.nsampleLocationsCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSampleLocationsInfoEXT.nsampleLocationsCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS));
        }
    }

    static {
        Struct.Layout layout = VkSampleLocationsInfoEXT.__struct(VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(POINTER_SIZE), VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SAMPLELOCATIONSPERPIXEL = layout.offsetof(2);
        SAMPLELOCATIONGRIDSIZE = layout.offsetof(3);
        SAMPLELOCATIONSCOUNT = layout.offsetof(4);
        PSAMPLELOCATIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSampleLocationsInfoEXT, Buffer>
    implements NativeResource {
        private static final VkSampleLocationsInfoEXT ELEMENT_FACTORY = VkSampleLocationsInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSampleLocationsInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSampleLocationsInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSampleLocationsInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int sampleLocationsPerPixel() {
            return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
        }

        public VkExtent2D sampleLocationGridSize() {
            return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleLocationsCount() {
            return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSampleLocationEXT const *")
        public VkSampleLocationEXT.Buffer pSampleLocations() {
            return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSampleLocationsInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000143000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSampleLocationsInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
            return this;
        }

        public Buffer sampleLocationGridSize(VkExtent2D value) {
            VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
            return this;
        }

        public Buffer sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.sampleLocationGridSize());
            return this;
        }

        public Buffer pSampleLocations(@Nullable @NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
            VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
            return this;
        }
    }
}

