/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSpecializationMapEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONSTANTID;
    public static final int OFFSET;
    public static final int SIZE;

    public VkSpecializationMapEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSpecializationMapEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int constantID() {
        return VkSpecializationMapEntry.nconstantID(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkSpecializationMapEntry.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return VkSpecializationMapEntry.nsize(this.address());
    }

    public VkSpecializationMapEntry constantID(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.nconstantID(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry offset(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.noffset(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry size(@NativeType(value="size_t") long value) {
        VkSpecializationMapEntry.nsize(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry set(int constantID, int offset, long size) {
        this.constantID(constantID);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkSpecializationMapEntry set(VkSpecializationMapEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSpecializationMapEntry malloc() {
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSpecializationMapEntry calloc() {
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSpecializationMapEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSpecializationMapEntry create(long address) {
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, address);
    }

    @Nullable
    public static VkSpecializationMapEntry createSafe(long address) {
        return address == 0L ? null : VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSpecializationMapEntry.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSpecializationMapEntry.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSpecializationMapEntry.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSpecializationMapEntry.__create(capacity, SIZEOF);
        return VkSpecializationMapEntry.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSpecializationMapEntry.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSpecializationMapEntry.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSpecializationMapEntry mallocStack() {
        return VkSpecializationMapEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationMapEntry callocStack() {
        return VkSpecializationMapEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationMapEntry mallocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.malloc(stack);
    }

    @Deprecated
    public static VkSpecializationMapEntry callocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSpecializationMapEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSpecializationMapEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.calloc(capacity, stack);
    }

    public static VkSpecializationMapEntry malloc(MemoryStack stack) {
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSpecializationMapEntry calloc(MemoryStack stack) {
        return VkSpecializationMapEntry.wrap(VkSpecializationMapEntry.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nconstantID(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONSTANTID);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void nconstantID(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONSTANTID, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkSpecializationMapEntry.__struct(VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONSTANTID = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationMapEntry, Buffer>
    implements NativeResource {
        private static final VkSpecializationMapEntry ELEMENT_FACTORY = VkSpecializationMapEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSpecializationMapEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int constantID() {
            return VkSpecializationMapEntry.nconstantID(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkSpecializationMapEntry.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return VkSpecializationMapEntry.nsize(this.address());
        }

        public Buffer constantID(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.nconstantID(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            VkSpecializationMapEntry.nsize(this.address(), value);
            return this;
        }
    }
}

