/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoDecodeH264CapabilitiesEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265CapabilitiesEXT;
import org.lwjgl.vulkan.VkVideoEncodeCapabilitiesKHR;

public class VkVideoCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CAPABILITYFLAGS;
    public static final int MINBITSTREAMBUFFEROFFSETALIGNMENT;
    public static final int MINBITSTREAMBUFFERSIZEALIGNMENT;
    public static final int VIDEOPICTUREEXTENTGRANULARITY;
    public static final int MINEXTENT;
    public static final int MAXEXTENT;
    public static final int MAXREFERENCEPICTURESSLOTSCOUNT;
    public static final int MAXREFERENCEPICTURESACTIVECOUNT;

    public VkVideoCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoCapabilitiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkVideoCapabilitiesKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoCapabilityFlagsKHR")
    public int capabilityFlags() {
        return VkVideoCapabilitiesKHR.ncapabilityFlags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minBitstreamBufferOffsetAlignment() {
        return VkVideoCapabilitiesKHR.nminBitstreamBufferOffsetAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minBitstreamBufferSizeAlignment() {
        return VkVideoCapabilitiesKHR.nminBitstreamBufferSizeAlignment(this.address());
    }

    public VkExtent2D videoPictureExtentGranularity() {
        return VkVideoCapabilitiesKHR.nvideoPictureExtentGranularity(this.address());
    }

    public VkExtent2D minExtent() {
        return VkVideoCapabilitiesKHR.nminExtent(this.address());
    }

    public VkExtent2D maxExtent() {
        return VkVideoCapabilitiesKHR.nmaxExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxReferencePicturesSlotsCount() {
        return VkVideoCapabilitiesKHR.nmaxReferencePicturesSlotsCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxReferencePicturesActiveCount() {
        return VkVideoCapabilitiesKHR.nmaxReferencePicturesActiveCount(this.address());
    }

    public VkVideoCapabilitiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoCapabilitiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoCapabilitiesKHR sType$Default() {
        return this.sType(1000023001);
    }

    public VkVideoCapabilitiesKHR pNext(@NativeType(value="void *") long value) {
        VkVideoCapabilitiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoDecodeH264CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoDecodeH265CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoEncodeCapabilitiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkVideoCapabilitiesKHR set(VkVideoCapabilitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoCapabilitiesKHR malloc() {
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoCapabilitiesKHR calloc() {
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoCapabilitiesKHR create(long address) {
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, address);
    }

    @Nullable
    public static VkVideoCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoCapabilitiesKHR.__create(capacity, SIZEOF);
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoCapabilitiesKHR malloc(MemoryStack stack) {
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoCapabilitiesKHR calloc(MemoryStack stack) {
        return VkVideoCapabilitiesKHR.wrap(VkVideoCapabilitiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoCapabilitiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncapabilityFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)CAPABILITYFLAGS);
    }

    public static long nminBitstreamBufferOffsetAlignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINBITSTREAMBUFFEROFFSETALIGNMENT);
    }

    public static long nminBitstreamBufferSizeAlignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINBITSTREAMBUFFERSIZEALIGNMENT);
    }

    public static VkExtent2D nvideoPictureExtentGranularity(long struct) {
        return VkExtent2D.create(struct + (long)VIDEOPICTUREEXTENTGRANULARITY);
    }

    public static VkExtent2D nminExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINEXTENT);
    }

    public static VkExtent2D nmaxExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXEXTENT);
    }

    public static int nmaxReferencePicturesSlotsCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXREFERENCEPICTURESSLOTSCOUNT);
    }

    public static int nmaxReferencePicturesActiveCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXREFERENCEPICTURESACTIVECOUNT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkVideoCapabilitiesKHR.__struct(VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(POINTER_SIZE), VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(8), VkVideoCapabilitiesKHR.__member(8), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CAPABILITYFLAGS = layout.offsetof(2);
        MINBITSTREAMBUFFEROFFSETALIGNMENT = layout.offsetof(3);
        MINBITSTREAMBUFFERSIZEALIGNMENT = layout.offsetof(4);
        VIDEOPICTUREEXTENTGRANULARITY = layout.offsetof(5);
        MINEXTENT = layout.offsetof(6);
        MAXEXTENT = layout.offsetof(7);
        MAXREFERENCEPICTURESSLOTSCOUNT = layout.offsetof(8);
        MAXREFERENCEPICTURESACTIVECOUNT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkVideoCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkVideoCapabilitiesKHR ELEMENT_FACTORY = VkVideoCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoCapabilitiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkVideoCapabilitiesKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoCapabilityFlagsKHR")
        public int capabilityFlags() {
            return VkVideoCapabilitiesKHR.ncapabilityFlags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minBitstreamBufferOffsetAlignment() {
            return VkVideoCapabilitiesKHR.nminBitstreamBufferOffsetAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minBitstreamBufferSizeAlignment() {
            return VkVideoCapabilitiesKHR.nminBitstreamBufferSizeAlignment(this.address());
        }

        public VkExtent2D videoPictureExtentGranularity() {
            return VkVideoCapabilitiesKHR.nvideoPictureExtentGranularity(this.address());
        }

        public VkExtent2D minExtent() {
            return VkVideoCapabilitiesKHR.nminExtent(this.address());
        }

        public VkExtent2D maxExtent() {
            return VkVideoCapabilitiesKHR.nmaxExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxReferencePicturesSlotsCount() {
            return VkVideoCapabilitiesKHR.nmaxReferencePicturesSlotsCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxReferencePicturesActiveCount() {
            return VkVideoCapabilitiesKHR.nmaxReferencePicturesActiveCount(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoCapabilitiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkVideoCapabilitiesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeH264CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeCapabilitiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

