/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoEncodeH264CapabilitiesEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265CapabilitiesEXT;

public class VkVideoEncodeCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RATECONTROLMODES;
    public static final int RATECONTROLLAYERCOUNT;
    public static final int QUALITYLEVELCOUNT;
    public static final int INPUTIMAGEDATAFILLALIGNMENT;

    public VkVideoEncodeCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeCapabilitiesKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeCapabilitiesKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeCapabilityFlagsKHR")
    public int flags() {
        return VkVideoEncodeCapabilitiesKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlModeFlagsKHR")
    public int rateControlModes() {
        return VkVideoEncodeCapabilitiesKHR.nrateControlModes(this.address());
    }

    @NativeType(value="uint8_t")
    public byte rateControlLayerCount() {
        return VkVideoEncodeCapabilitiesKHR.nrateControlLayerCount(this.address());
    }

    @NativeType(value="uint8_t")
    public byte qualityLevelCount() {
        return VkVideoEncodeCapabilitiesKHR.nqualityLevelCount(this.address());
    }

    public VkExtent2D inputImageDataFillAlignment() {
        return VkVideoEncodeCapabilitiesKHR.ninputImageDataFillAlignment(this.address());
    }

    public VkVideoEncodeCapabilitiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeCapabilitiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR sType$Default() {
        return this.sType(1000299003);
    }

    public VkVideoEncodeCapabilitiesKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeCapabilitiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR pNext(VkVideoEncodeH264CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeCapabilitiesKHR pNext(VkVideoEncodeH265CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeCapabilitiesKHR flags(@NativeType(value="VkVideoEncodeCapabilityFlagsKHR") int value) {
        VkVideoEncodeCapabilitiesKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR rateControlModes(@NativeType(value="VkVideoEncodeRateControlModeFlagsKHR") int value) {
        VkVideoEncodeCapabilitiesKHR.nrateControlModes(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR rateControlLayerCount(@NativeType(value="uint8_t") byte value) {
        VkVideoEncodeCapabilitiesKHR.nrateControlLayerCount(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR qualityLevelCount(@NativeType(value="uint8_t") byte value) {
        VkVideoEncodeCapabilitiesKHR.nqualityLevelCount(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR inputImageDataFillAlignment(VkExtent2D value) {
        VkVideoEncodeCapabilitiesKHR.ninputImageDataFillAlignment(this.address(), value);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR inputImageDataFillAlignment(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.inputImageDataFillAlignment());
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR set(int sType, long pNext, int flags, int rateControlModes, byte rateControlLayerCount, byte qualityLevelCount, VkExtent2D inputImageDataFillAlignment) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.rateControlModes(rateControlModes);
        this.rateControlLayerCount(rateControlLayerCount);
        this.qualityLevelCount(qualityLevelCount);
        this.inputImageDataFillAlignment(inputImageDataFillAlignment);
        return this;
    }

    public VkVideoEncodeCapabilitiesKHR set(VkVideoEncodeCapabilitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeCapabilitiesKHR malloc() {
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoEncodeCapabilitiesKHR calloc() {
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoEncodeCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeCapabilitiesKHR create(long address) {
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, address);
    }

    @Nullable
    public static VkVideoEncodeCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoEncodeCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeCapabilitiesKHR.__create(capacity, SIZEOF);
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoEncodeCapabilitiesKHR malloc(MemoryStack stack) {
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoEncodeCapabilitiesKHR calloc(MemoryStack stack) {
        return VkVideoEncodeCapabilitiesKHR.wrap(VkVideoEncodeCapabilitiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeCapabilitiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nrateControlModes(long struct) {
        return UNSAFE.getInt(null, struct + (long)RATECONTROLMODES);
    }

    public static byte nrateControlLayerCount(long struct) {
        return UNSAFE.getByte(null, struct + (long)RATECONTROLLAYERCOUNT);
    }

    public static byte nqualityLevelCount(long struct) {
        return UNSAFE.getByte(null, struct + (long)QUALITYLEVELCOUNT);
    }

    public static VkExtent2D ninputImageDataFillAlignment(long struct) {
        return VkExtent2D.create(struct + (long)INPUTIMAGEDATAFILLALIGNMENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrateControlModes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RATECONTROLMODES, value);
    }

    public static void nrateControlLayerCount(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RATECONTROLLAYERCOUNT, value);
    }

    public static void nqualityLevelCount(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)QUALITYLEVELCOUNT, value);
    }

    public static void ninputImageDataFillAlignment(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INPUTIMAGEDATAFILLALIGNMENT, VkExtent2D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkVideoEncodeCapabilitiesKHR.__struct(VkVideoEncodeCapabilitiesKHR.__member(4), VkVideoEncodeCapabilitiesKHR.__member(POINTER_SIZE), VkVideoEncodeCapabilitiesKHR.__member(4), VkVideoEncodeCapabilitiesKHR.__member(4), VkVideoEncodeCapabilitiesKHR.__member(1), VkVideoEncodeCapabilitiesKHR.__member(1), VkVideoEncodeCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RATECONTROLMODES = layout.offsetof(3);
        RATECONTROLLAYERCOUNT = layout.offsetof(4);
        QUALITYLEVELCOUNT = layout.offsetof(5);
        INPUTIMAGEDATAFILLALIGNMENT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeCapabilitiesKHR ELEMENT_FACTORY = VkVideoEncodeCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeCapabilitiesKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeCapabilitiesKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeCapabilityFlagsKHR")
        public int flags() {
            return VkVideoEncodeCapabilitiesKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlModeFlagsKHR")
        public int rateControlModes() {
            return VkVideoEncodeCapabilitiesKHR.nrateControlModes(this.address());
        }

        @NativeType(value="uint8_t")
        public byte rateControlLayerCount() {
            return VkVideoEncodeCapabilitiesKHR.nrateControlLayerCount(this.address());
        }

        @NativeType(value="uint8_t")
        public byte qualityLevelCount() {
            return VkVideoEncodeCapabilitiesKHR.nqualityLevelCount(this.address());
        }

        public VkExtent2D inputImageDataFillAlignment() {
            return VkVideoEncodeCapabilitiesKHR.ninputImageDataFillAlignment(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeCapabilitiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeCapabilitiesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeH264CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeCapabilityFlagsKHR") int value) {
            VkVideoEncodeCapabilitiesKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer rateControlModes(@NativeType(value="VkVideoEncodeRateControlModeFlagsKHR") int value) {
            VkVideoEncodeCapabilitiesKHR.nrateControlModes(this.address(), value);
            return this;
        }

        public Buffer rateControlLayerCount(@NativeType(value="uint8_t") byte value) {
            VkVideoEncodeCapabilitiesKHR.nrateControlLayerCount(this.address(), value);
            return this;
        }

        public Buffer qualityLevelCount(@NativeType(value="uint8_t") byte value) {
            VkVideoEncodeCapabilitiesKHR.nqualityLevelCount(this.address(), value);
            return this;
        }

        public Buffer inputImageDataFillAlignment(VkExtent2D value) {
            VkVideoEncodeCapabilitiesKHR.ninputImageDataFillAlignment(this.address(), value);
            return this;
        }

        public Buffer inputImageDataFillAlignment(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.inputImageDataFillAlignment());
            return this;
        }
    }
}

