/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVideoEncodeH264FrameSizeEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMEISIZE;
    public static final int FRAMEPSIZE;
    public static final int FRAMEBSIZE;

    public VkVideoEncodeH264FrameSizeEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeH264FrameSizeEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int frameISize() {
        return VkVideoEncodeH264FrameSizeEXT.nframeISize(this.address());
    }

    @NativeType(value="uint32_t")
    public int framePSize() {
        return VkVideoEncodeH264FrameSizeEXT.nframePSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameBSize() {
        return VkVideoEncodeH264FrameSizeEXT.nframeBSize(this.address());
    }

    public VkVideoEncodeH264FrameSizeEXT frameISize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH264FrameSizeEXT.nframeISize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264FrameSizeEXT framePSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH264FrameSizeEXT.nframePSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264FrameSizeEXT frameBSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH264FrameSizeEXT.nframeBSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264FrameSizeEXT set(int frameISize, int framePSize, int frameBSize) {
        this.frameISize(frameISize);
        this.framePSize(framePSize);
        this.frameBSize(frameBSize);
        return this;
    }

    public VkVideoEncodeH264FrameSizeEXT set(VkVideoEncodeH264FrameSizeEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeH264FrameSizeEXT malloc() {
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoEncodeH264FrameSizeEXT calloc() {
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoEncodeH264FrameSizeEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeH264FrameSizeEXT create(long address) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, address);
    }

    @Nullable
    public static VkVideoEncodeH264FrameSizeEXT createSafe(long address) {
        return address == 0L ? null : VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoEncodeH264FrameSizeEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeH264FrameSizeEXT.__create(capacity, SIZEOF);
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoEncodeH264FrameSizeEXT malloc(MemoryStack stack) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoEncodeH264FrameSizeEXT calloc(MemoryStack stack) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(VkVideoEncodeH264FrameSizeEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeH264FrameSizeEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nframeISize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEISIZE);
    }

    public static int nframePSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEPSIZE);
    }

    public static int nframeBSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEBSIZE);
    }

    public static void nframeISize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEISIZE, value);
    }

    public static void nframePSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEPSIZE, value);
    }

    public static void nframeBSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEBSIZE, value);
    }

    static {
        Struct.Layout layout = VkVideoEncodeH264FrameSizeEXT.__struct(VkVideoEncodeH264FrameSizeEXT.__member(4), VkVideoEncodeH264FrameSizeEXT.__member(4), VkVideoEncodeH264FrameSizeEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMEISIZE = layout.offsetof(0);
        FRAMEPSIZE = layout.offsetof(1);
        FRAMEBSIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeH264FrameSizeEXT, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeH264FrameSizeEXT ELEMENT_FACTORY = VkVideoEncodeH264FrameSizeEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeH264FrameSizeEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int frameISize() {
            return VkVideoEncodeH264FrameSizeEXT.nframeISize(this.address());
        }

        @NativeType(value="uint32_t")
        public int framePSize() {
            return VkVideoEncodeH264FrameSizeEXT.nframePSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int frameBSize() {
            return VkVideoEncodeH264FrameSizeEXT.nframeBSize(this.address());
        }

        public Buffer frameISize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH264FrameSizeEXT.nframeISize(this.address(), value);
            return this;
        }

        public Buffer framePSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH264FrameSizeEXT.nframePSize(this.address(), value);
            return this;
        }

        public Buffer frameBSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH264FrameSizeEXT.nframeBSize(this.address(), value);
            return this;
        }
    }
}

