/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoEncodeH264EmitPictureParametersEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264VclFrameInfoEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265EmitPictureParametersEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265VclFrameInfoEXT;
import org.lwjgl.vulkan.VkVideoPictureResourceKHR;
import org.lwjgl.vulkan.VkVideoReferenceSlotKHR;

public class VkVideoEncodeInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUALITYLEVEL;
    public static final int CODEDEXTENT;
    public static final int DSTBITSTREAMBUFFER;
    public static final int DSTBITSTREAMBUFFEROFFSET;
    public static final int DSTBITSTREAMBUFFERMAXRANGE;
    public static final int SRCPICTURERESOURCE;
    public static final int PSETUPREFERENCESLOT;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;
    public static final int PRECEDINGEXTERNALLYENCODEDBYTES;

    public VkVideoEncodeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeFlagsKHR")
    public int flags() {
        return VkVideoEncodeInfoKHR.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int qualityLevel() {
        return VkVideoEncodeInfoKHR.nqualityLevel(this.address());
    }

    public VkExtent2D codedExtent() {
        return VkVideoEncodeInfoKHR.ncodedExtent(this.address());
    }

    @NativeType(value="VkBuffer")
    public long dstBitstreamBuffer() {
        return VkVideoEncodeInfoKHR.ndstBitstreamBuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBitstreamBufferOffset() {
        return VkVideoEncodeInfoKHR.ndstBitstreamBufferOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBitstreamBufferMaxRange() {
        return VkVideoEncodeInfoKHR.ndstBitstreamBufferMaxRange(this.address());
    }

    public VkVideoPictureResourceKHR srcPictureResource() {
        return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotKHR const *")
    public VkVideoReferenceSlotKHR pSetupReferenceSlot() {
        return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
    }

    @Nullable
    @NativeType(value="VkVideoReferenceSlotKHR const *")
    public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
        return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int precedingExternallyEncodedBytes() {
        return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
    }

    public VkVideoEncodeInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR sType$Default() {
        return this.sType(1000299000);
    }

    public VkVideoEncodeInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH264EmitPictureParametersEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH264VclFrameInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH265EmitPictureParametersEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH265VclFrameInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
        VkVideoEncodeInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR qualityLevel(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeInfoKHR.nqualityLevel(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR codedExtent(VkExtent2D value) {
        VkVideoEncodeInfoKHR.ncodedExtent(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR codedExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.codedExtent());
        return this;
    }

    public VkVideoEncodeInfoKHR dstBitstreamBuffer(@NativeType(value="VkBuffer") long value) {
        VkVideoEncodeInfoKHR.ndstBitstreamBuffer(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBitstreamBufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBitstreamBufferOffset(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBitstreamBufferMaxRange(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBitstreamBufferMaxRange(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(VkVideoPictureResourceKHR value) {
        VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(Consumer<VkVideoPictureResourceKHR> consumer) {
        consumer.accept(this.srcPictureResource());
        return this;
    }

    public VkVideoEncodeInfoKHR pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR value) {
        VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
        VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR set(int sType, long pNext, int flags, int qualityLevel, VkExtent2D codedExtent, long dstBitstreamBuffer, long dstBitstreamBufferOffset, long dstBitstreamBufferMaxRange, VkVideoPictureResourceKHR srcPictureResource, VkVideoReferenceSlotKHR pSetupReferenceSlot, @Nullable VkVideoReferenceSlotKHR.Buffer pReferenceSlots, int precedingExternallyEncodedBytes) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.qualityLevel(qualityLevel);
        this.codedExtent(codedExtent);
        this.dstBitstreamBuffer(dstBitstreamBuffer);
        this.dstBitstreamBufferOffset(dstBitstreamBufferOffset);
        this.dstBitstreamBufferMaxRange(dstBitstreamBufferMaxRange);
        this.srcPictureResource(srcPictureResource);
        this.pSetupReferenceSlot(pSetupReferenceSlot);
        this.pReferenceSlots(pReferenceSlots);
        this.precedingExternallyEncodedBytes(precedingExternallyEncodedBytes);
        return this;
    }

    public VkVideoEncodeInfoKHR set(VkVideoEncodeInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeInfoKHR malloc() {
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoEncodeInfoKHR calloc() {
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoEncodeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeInfoKHR create(long address) {
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, address);
    }

    @Nullable
    public static VkVideoEncodeInfoKHR createSafe(long address) {
        return address == 0L ? null : VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoEncodeInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeInfoKHR.__create(capacity, SIZEOF);
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoEncodeInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoEncodeInfoKHR malloc(MemoryStack stack) {
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoEncodeInfoKHR calloc(MemoryStack stack) {
        return VkVideoEncodeInfoKHR.wrap(VkVideoEncodeInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nqualityLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUALITYLEVEL);
    }

    public static VkExtent2D ncodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)CODEDEXTENT);
    }

    public static long ndstBitstreamBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBITSTREAMBUFFER);
    }

    public static long ndstBitstreamBufferOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBITSTREAMBUFFEROFFSET);
    }

    public static long ndstBitstreamBufferMaxRange(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBITSTREAMBUFFERMAXRANGE);
    }

    public static VkVideoPictureResourceKHR nsrcPictureResource(long struct) {
        return VkVideoPictureResourceKHR.create(struct + (long)SRCPICTURERESOURCE);
    }

    public static VkVideoReferenceSlotKHR npSetupReferenceSlot(long struct) {
        return VkVideoReferenceSlotKHR.create(MemoryUtil.memGetAddress(struct + (long)PSETUPREFERENCESLOT));
    }

    public static int nreferenceSlotCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESLOTCOUNT);
    }

    @Nullable
    public static VkVideoReferenceSlotKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS), VkVideoEncodeInfoKHR.nreferenceSlotCount(struct));
    }

    public static int nprecedingExternallyEncodedBytes(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nqualityLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUALITYLEVEL, value);
    }

    public static void ncodedExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CODEDEXTENT, VkExtent2D.SIZEOF);
    }

    public static void ndstBitstreamBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBITSTREAMBUFFER, value);
    }

    public static void ndstBitstreamBufferOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBITSTREAMBUFFEROFFSET, value);
    }

    public static void ndstBitstreamBufferMaxRange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBITSTREAMBUFFERMAXRANGE, value);
    }

    public static void nsrcPictureResource(long struct, VkVideoPictureResourceKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCPICTURERESOURCE, VkVideoPictureResourceKHR.SIZEOF);
    }

    public static void npSetupReferenceSlot(long struct, VkVideoReferenceSlotKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PSETUPREFERENCESLOT, value.address());
    }

    public static void nreferenceSlotCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREFERENCESLOTS, MemoryUtil.memAddressSafe(value));
        VkVideoEncodeInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nprecedingExternallyEncodedBytes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES, value);
    }

    public static void validate(long struct) {
        long pSetupReferenceSlot = MemoryUtil.memGetAddress(struct + (long)PSETUPREFERENCESLOT);
        Checks.check(pSetupReferenceSlot);
        VkVideoReferenceSlotKHR.validate(pSetupReferenceSlot);
        int referenceSlotCount = VkVideoEncodeInfoKHR.nreferenceSlotCount(struct);
        if (referenceSlotCount != 0) {
            long pReferenceSlots = MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS);
            Checks.check(pReferenceSlots);
            VkVideoEncodeInfoKHR.validate(pReferenceSlots, referenceSlotCount, VkVideoReferenceSlotKHR.SIZEOF, VkVideoReferenceSlotKHR::validate);
        }
    }

    static {
        Struct.Layout layout = VkVideoEncodeInfoKHR.__struct(VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(VkVideoPictureResourceKHR.SIZEOF, VkVideoPictureResourceKHR.ALIGNOF), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUALITYLEVEL = layout.offsetof(3);
        CODEDEXTENT = layout.offsetof(4);
        DSTBITSTREAMBUFFER = layout.offsetof(5);
        DSTBITSTREAMBUFFEROFFSET = layout.offsetof(6);
        DSTBITSTREAMBUFFERMAXRANGE = layout.offsetof(7);
        SRCPICTURERESOURCE = layout.offsetof(8);
        PSETUPREFERENCESLOT = layout.offsetof(9);
        REFERENCESLOTCOUNT = layout.offsetof(10);
        PREFERENCESLOTS = layout.offsetof(11);
        PRECEDINGEXTERNALLYENCODEDBYTES = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeInfoKHR ELEMENT_FACTORY = VkVideoEncodeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeFlagsKHR")
        public int flags() {
            return VkVideoEncodeInfoKHR.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int qualityLevel() {
            return VkVideoEncodeInfoKHR.nqualityLevel(this.address());
        }

        public VkExtent2D codedExtent() {
            return VkVideoEncodeInfoKHR.ncodedExtent(this.address());
        }

        @NativeType(value="VkBuffer")
        public long dstBitstreamBuffer() {
            return VkVideoEncodeInfoKHR.ndstBitstreamBuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBitstreamBufferOffset() {
            return VkVideoEncodeInfoKHR.ndstBitstreamBufferOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBitstreamBufferMaxRange() {
            return VkVideoEncodeInfoKHR.ndstBitstreamBufferMaxRange(this.address());
        }

        public VkVideoPictureResourceKHR srcPictureResource() {
            return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotKHR const *")
        public VkVideoReferenceSlotKHR pSetupReferenceSlot() {
            return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
        }

        @Nullable
        @NativeType(value="VkVideoReferenceSlotKHR const *")
        public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
            return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int precedingExternallyEncodedBytes() {
            return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeH264EmitPictureParametersEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264VclFrameInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265EmitPictureParametersEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265VclFrameInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
            VkVideoEncodeInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer qualityLevel(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeInfoKHR.nqualityLevel(this.address(), value);
            return this;
        }

        public Buffer codedExtent(VkExtent2D value) {
            VkVideoEncodeInfoKHR.ncodedExtent(this.address(), value);
            return this;
        }

        public Buffer codedExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.codedExtent());
            return this;
        }

        public Buffer dstBitstreamBuffer(@NativeType(value="VkBuffer") long value) {
            VkVideoEncodeInfoKHR.ndstBitstreamBuffer(this.address(), value);
            return this;
        }

        public Buffer dstBitstreamBufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBitstreamBufferOffset(this.address(), value);
            return this;
        }

        public Buffer dstBitstreamBufferMaxRange(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBitstreamBufferMaxRange(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(VkVideoPictureResourceKHR value) {
            VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(Consumer<VkVideoPictureResourceKHR> consumer) {
            consumer.accept(this.srcPictureResource());
            return this;
        }

        public Buffer pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR value) {
            VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
            VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }

        public Buffer precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
            return this;
        }
    }
}

