/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoDecodeH264SessionCreateInfoEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265SessionCreateInfoEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264SessionCreateInfoEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265SessionCreateInfoEXT;
import org.lwjgl.vulkan.VkVideoProfileKHR;

public class VkVideoSessionCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int QUEUEFAMILYINDEX;
    public static final int FLAGS;
    public static final int PVIDEOPROFILE;
    public static final int PICTUREFORMAT;
    public static final int MAXCODEDEXTENT;
    public static final int REFERENCEPICTURESFORMAT;
    public static final int MAXREFERENCEPICTURESSLOTSCOUNT;
    public static final int MAXREFERENCEPICTURESACTIVECOUNT;

    public VkVideoSessionCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoSessionCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoSessionCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoSessionCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="VkVideoSessionCreateFlagsKHR")
    public int flags() {
        return VkVideoSessionCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoProfileKHR const *")
    public VkVideoProfileKHR pVideoProfile() {
        return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
    }

    @NativeType(value="VkFormat")
    public int pictureFormat() {
        return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
    }

    public VkExtent2D maxCodedExtent() {
        return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
    }

    @NativeType(value="VkFormat")
    public int referencePicturesFormat() {
        return VkVideoSessionCreateInfoKHR.nreferencePicturesFormat(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxReferencePicturesSlotsCount() {
        return VkVideoSessionCreateInfoKHR.nmaxReferencePicturesSlotsCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxReferencePicturesActiveCount() {
        return VkVideoSessionCreateInfoKHR.nmaxReferencePicturesActiveCount(this.address());
    }

    public VkVideoSessionCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR sType$Default() {
        return this.sType(1000023005);
    }

    public VkVideoSessionCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoDecodeH264SessionCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoDecodeH265SessionCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH264SessionCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH265SessionCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
        VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pVideoProfile(@NativeType(value="VkVideoProfileKHR const *") VkVideoProfileKHR value) {
        VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pictureFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(VkExtent2D value) {
        VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxCodedExtent());
        return this;
    }

    public VkVideoSessionCreateInfoKHR referencePicturesFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.nreferencePicturesFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxReferencePicturesSlotsCount(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxReferencePicturesSlotsCount(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxReferencePicturesActiveCount(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxReferencePicturesActiveCount(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(int sType, long pNext, int queueFamilyIndex, int flags, VkVideoProfileKHR pVideoProfile, int pictureFormat, VkExtent2D maxCodedExtent, int referencePicturesFormat, int maxReferencePicturesSlotsCount, int maxReferencePicturesActiveCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.queueFamilyIndex(queueFamilyIndex);
        this.flags(flags);
        this.pVideoProfile(pVideoProfile);
        this.pictureFormat(pictureFormat);
        this.maxCodedExtent(maxCodedExtent);
        this.referencePicturesFormat(referencePicturesFormat);
        this.maxReferencePicturesSlotsCount(maxReferencePicturesSlotsCount);
        this.maxReferencePicturesActiveCount(maxReferencePicturesActiveCount);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(VkVideoSessionCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoSessionCreateInfoKHR malloc() {
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoSessionCreateInfoKHR calloc() {
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoSessionCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoSessionCreateInfoKHR create(long address) {
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkVideoSessionCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoSessionCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoSessionCreateInfoKHR.__create(capacity, SIZEOF);
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoSessionCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoSessionCreateInfoKHR malloc(MemoryStack stack) {
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoSessionCreateInfoKHR calloc(MemoryStack stack) {
        return VkVideoSessionCreateInfoKHR.wrap(VkVideoSessionCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoSessionCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nqueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkVideoProfileKHR npVideoProfile(long struct) {
        return VkVideoProfileKHR.create(MemoryUtil.memGetAddress(struct + (long)PVIDEOPROFILE));
    }

    public static int npictureFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICTUREFORMAT);
    }

    public static VkExtent2D nmaxCodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXCODEDEXTENT);
    }

    public static int nreferencePicturesFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCEPICTURESFORMAT);
    }

    public static int nmaxReferencePicturesSlotsCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXREFERENCEPICTURESSLOTSCOUNT);
    }

    public static int nmaxReferencePicturesActiveCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXREFERENCEPICTURESACTIVECOUNT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npVideoProfile(long struct, VkVideoProfileKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PVIDEOPROFILE, value.address());
    }

    public static void npictureFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICTUREFORMAT, value);
    }

    public static void nmaxCodedExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MAXCODEDEXTENT, VkExtent2D.SIZEOF);
    }

    public static void nreferencePicturesFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCEPICTURESFORMAT, value);
    }

    public static void nmaxReferencePicturesSlotsCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXREFERENCEPICTURESSLOTSCOUNT, value);
    }

    public static void nmaxReferencePicturesActiveCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXREFERENCEPICTURESACTIVECOUNT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIDEOPROFILE));
    }

    static {
        Struct.Layout layout = VkVideoSessionCreateInfoKHR.__struct(VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        QUEUEFAMILYINDEX = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        PVIDEOPROFILE = layout.offsetof(4);
        PICTUREFORMAT = layout.offsetof(5);
        MAXCODEDEXTENT = layout.offsetof(6);
        REFERENCEPICTURESFORMAT = layout.offsetof(7);
        MAXREFERENCEPICTURESSLOTSCOUNT = layout.offsetof(8);
        MAXREFERENCEPICTURESACTIVECOUNT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkVideoSessionCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoSessionCreateInfoKHR ELEMENT_FACTORY = VkVideoSessionCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoSessionCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoSessionCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoSessionCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="VkVideoSessionCreateFlagsKHR")
        public int flags() {
            return VkVideoSessionCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoProfileKHR const *")
        public VkVideoProfileKHR pVideoProfile() {
            return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
        }

        @NativeType(value="VkFormat")
        public int pictureFormat() {
            return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
        }

        public VkExtent2D maxCodedExtent() {
            return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
        }

        @NativeType(value="VkFormat")
        public int referencePicturesFormat() {
            return VkVideoSessionCreateInfoKHR.nreferencePicturesFormat(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxReferencePicturesSlotsCount() {
            return VkVideoSessionCreateInfoKHR.nmaxReferencePicturesSlotsCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxReferencePicturesActiveCount() {
            return VkVideoSessionCreateInfoKHR.nmaxReferencePicturesActiveCount(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeH264SessionCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265SessionCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264SessionCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265SessionCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
            VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pVideoProfile(@NativeType(value="VkVideoProfileKHR const *") VkVideoProfileKHR value) {
            VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
            return this;
        }

        public Buffer pictureFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(VkExtent2D value) {
            VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxCodedExtent());
            return this;
        }

        public Buffer referencePicturesFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.nreferencePicturesFormat(this.address(), value);
            return this;
        }

        public Buffer maxReferencePicturesSlotsCount(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxReferencePicturesSlotsCount(this.address(), value);
            return this;
        }

        public Buffer maxReferencePicturesActiveCount(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxReferencePicturesActiveCount(this.address(), value);
            return this;
        }
    }
}

