/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH264MvcElementFlags;

public class StdVideoDecodeH264MvcElement
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int VIEWORDERINDEX;
    public static final int VIEWID;
    public static final int TEMPORALID;
    public static final int PRIORITYID;
    public static final int NUMOFANCHORREFSINL0;
    public static final int VIEWIDOFANCHORREFSINL0;
    public static final int NUMOFANCHORREFSINL1;
    public static final int VIEWIDOFANCHORREFSINL1;
    public static final int NUMOFNONANCHORREFSINL0;
    public static final int VIEWIDOFNONANCHORREFSINL0;
    public static final int NUMOFNONANCHORREFSINL1;
    public static final int VIEWIDOFNONANCHORREFSINL1;

    public StdVideoDecodeH264MvcElement(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoDecodeH264MvcElement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoDecodeH264MvcElementFlags flags() {
        return StdVideoDecodeH264MvcElement.nflags(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewOrderIndex() {
        return StdVideoDecodeH264MvcElement.nviewOrderIndex(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewId() {
        return StdVideoDecodeH264MvcElement.nviewId(this.address());
    }

    @NativeType(value="uint16_t")
    public short temporalId() {
        return StdVideoDecodeH264MvcElement.ntemporalId(this.address());
    }

    @NativeType(value="uint16_t")
    public short priorityId() {
        return StdVideoDecodeH264MvcElement.npriorityId(this.address());
    }

    @NativeType(value="uint16_t")
    public short numOfAnchorRefsInL0() {
        return StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL0(this.address());
    }

    @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
    public ShortBuffer viewIdOfAnchorRefsInL0() {
        return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewIdOfAnchorRefsInL0(int index) {
        return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), index);
    }

    @NativeType(value="uint16_t")
    public short numOfAnchorRefsInL1() {
        return StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL1(this.address());
    }

    @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
    public ShortBuffer viewIdOfAnchorRefsInL1() {
        return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewIdOfAnchorRefsInL1(int index) {
        return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), index);
    }

    @NativeType(value="uint16_t")
    public short numOfNonAnchorRefsInL0() {
        return StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL0(this.address());
    }

    @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
    public ShortBuffer viewIdOfNonAnchorRefsInL0() {
        return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewIdOfNonAnchorRefsInL0(int index) {
        return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), index);
    }

    @NativeType(value="uint16_t")
    public short numOfNonAnchorRefsInL1() {
        return StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL1(this.address());
    }

    @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
    public ShortBuffer viewIdOfNonAnchorRefsInL1() {
        return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address());
    }

    @NativeType(value="uint16_t")
    public short viewIdOfNonAnchorRefsInL1(int index) {
        return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), index);
    }

    public StdVideoDecodeH264MvcElement flags(StdVideoDecodeH264MvcElementFlags value) {
        StdVideoDecodeH264MvcElement.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement flags(Consumer<StdVideoDecodeH264MvcElementFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH264MvcElement viewOrderIndex(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewOrderIndex(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewId(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewId(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement temporalId(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.ntemporalId(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement priorityId(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.npriorityId(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement numOfAnchorRefsInL0(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL0(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfAnchorRefsInL0(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
        StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfAnchorRefsInL0(int index, @NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264MvcElement numOfAnchorRefsInL1(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL1(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfAnchorRefsInL1(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
        StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfAnchorRefsInL1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264MvcElement numOfNonAnchorRefsInL0(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL0(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfNonAnchorRefsInL0(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
        StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfNonAnchorRefsInL0(int index, @NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264MvcElement numOfNonAnchorRefsInL1(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL1(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfNonAnchorRefsInL1(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
        StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264MvcElement viewIdOfNonAnchorRefsInL1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264MvcElement set(StdVideoDecodeH264MvcElementFlags flags, short viewOrderIndex, short viewId, short temporalId, short priorityId, short numOfAnchorRefsInL0, ShortBuffer viewIdOfAnchorRefsInL0, short numOfAnchorRefsInL1, ShortBuffer viewIdOfAnchorRefsInL1, short numOfNonAnchorRefsInL0, ShortBuffer viewIdOfNonAnchorRefsInL0, short numOfNonAnchorRefsInL1, ShortBuffer viewIdOfNonAnchorRefsInL1) {
        this.flags(flags);
        this.viewOrderIndex(viewOrderIndex);
        this.viewId(viewId);
        this.temporalId(temporalId);
        this.priorityId(priorityId);
        this.numOfAnchorRefsInL0(numOfAnchorRefsInL0);
        this.viewIdOfAnchorRefsInL0(viewIdOfAnchorRefsInL0);
        this.numOfAnchorRefsInL1(numOfAnchorRefsInL1);
        this.viewIdOfAnchorRefsInL1(viewIdOfAnchorRefsInL1);
        this.numOfNonAnchorRefsInL0(numOfNonAnchorRefsInL0);
        this.viewIdOfNonAnchorRefsInL0(viewIdOfNonAnchorRefsInL0);
        this.numOfNonAnchorRefsInL1(numOfNonAnchorRefsInL1);
        this.viewIdOfNonAnchorRefsInL1(viewIdOfNonAnchorRefsInL1);
        return this;
    }

    public StdVideoDecodeH264MvcElement set(StdVideoDecodeH264MvcElement src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoDecodeH264MvcElement malloc() {
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoDecodeH264MvcElement calloc() {
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoDecodeH264MvcElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoDecodeH264MvcElement create(long address) {
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, address);
    }

    @Nullable
    public static StdVideoDecodeH264MvcElement createSafe(long address) {
        return address == 0L ? null : StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoDecodeH264MvcElement.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH264MvcElement.__create(capacity, SIZEOF);
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoDecodeH264MvcElement.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoDecodeH264MvcElement malloc(MemoryStack stack) {
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoDecodeH264MvcElement calloc(MemoryStack stack) {
        return StdVideoDecodeH264MvcElement.wrap(StdVideoDecodeH264MvcElement.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH264MvcElement.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoDecodeH264MvcElementFlags nflags(long struct) {
        return StdVideoDecodeH264MvcElementFlags.create(struct + (long)FLAGS);
    }

    public static short nviewOrderIndex(long struct) {
        return UNSAFE.getShort(null, struct + (long)VIEWORDERINDEX);
    }

    public static short nviewId(long struct) {
        return UNSAFE.getShort(null, struct + (long)VIEWID);
    }

    public static short ntemporalId(long struct) {
        return UNSAFE.getShort(null, struct + (long)TEMPORALID);
    }

    public static short npriorityId(long struct) {
        return UNSAFE.getShort(null, struct + (long)PRIORITYID);
    }

    public static short nnumOfAnchorRefsInL0(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMOFANCHORREFSINL0);
    }

    public static ShortBuffer nviewIdOfAnchorRefsInL0(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)VIEWIDOFANCHORREFSINL0, 15);
    }

    public static short nviewIdOfAnchorRefsInL0(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)VIEWIDOFANCHORREFSINL0 + Checks.check(index, 15) * 2L);
    }

    public static short nnumOfAnchorRefsInL1(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMOFANCHORREFSINL1);
    }

    public static ShortBuffer nviewIdOfAnchorRefsInL1(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)VIEWIDOFANCHORREFSINL1, 15);
    }

    public static short nviewIdOfAnchorRefsInL1(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)VIEWIDOFANCHORREFSINL1 + Checks.check(index, 15) * 2L);
    }

    public static short nnumOfNonAnchorRefsInL0(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMOFNONANCHORREFSINL0);
    }

    public static ShortBuffer nviewIdOfNonAnchorRefsInL0(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)VIEWIDOFNONANCHORREFSINL0, 15);
    }

    public static short nviewIdOfNonAnchorRefsInL0(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)VIEWIDOFNONANCHORREFSINL0 + Checks.check(index, 15) * 2L);
    }

    public static short nnumOfNonAnchorRefsInL1(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMOFNONANCHORREFSINL1);
    }

    public static ShortBuffer nviewIdOfNonAnchorRefsInL1(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)VIEWIDOFNONANCHORREFSINL1, 15);
    }

    public static short nviewIdOfNonAnchorRefsInL1(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)VIEWIDOFNONANCHORREFSINL1 + Checks.check(index, 15) * 2L);
    }

    public static void nflags(long struct, StdVideoDecodeH264MvcElementFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoDecodeH264MvcElementFlags.SIZEOF);
    }

    public static void nviewOrderIndex(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWORDERINDEX, value);
    }

    public static void nviewId(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWID, value);
    }

    public static void ntemporalId(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)TEMPORALID, value);
    }

    public static void npriorityId(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)PRIORITYID, value);
    }

    public static void nnumOfAnchorRefsInL0(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMOFANCHORREFSINL0, value);
    }

    public static void nviewIdOfAnchorRefsInL0(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VIEWIDOFANCHORREFSINL0, value.remaining() * 2);
    }

    public static void nviewIdOfAnchorRefsInL0(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWIDOFANCHORREFSINL0 + Checks.check(index, 15) * 2L, value);
    }

    public static void nnumOfAnchorRefsInL1(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMOFANCHORREFSINL1, value);
    }

    public static void nviewIdOfAnchorRefsInL1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VIEWIDOFANCHORREFSINL1, value.remaining() * 2);
    }

    public static void nviewIdOfAnchorRefsInL1(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWIDOFANCHORREFSINL1 + Checks.check(index, 15) * 2L, value);
    }

    public static void nnumOfNonAnchorRefsInL0(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMOFNONANCHORREFSINL0, value);
    }

    public static void nviewIdOfNonAnchorRefsInL0(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VIEWIDOFNONANCHORREFSINL0, value.remaining() * 2);
    }

    public static void nviewIdOfNonAnchorRefsInL0(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWIDOFNONANCHORREFSINL0 + Checks.check(index, 15) * 2L, value);
    }

    public static void nnumOfNonAnchorRefsInL1(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMOFNONANCHORREFSINL1, value);
    }

    public static void nviewIdOfNonAnchorRefsInL1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VIEWIDOFNONANCHORREFSINL1, value.remaining() * 2);
    }

    public static void nviewIdOfNonAnchorRefsInL1(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)VIEWIDOFNONANCHORREFSINL1 + Checks.check(index, 15) * 2L, value);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH264MvcElement.__struct(StdVideoDecodeH264MvcElement.__member(StdVideoDecodeH264MvcElementFlags.SIZEOF, StdVideoDecodeH264MvcElementFlags.ALIGNOF), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__array(2, 15), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__array(2, 15), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__array(2, 15), StdVideoDecodeH264MvcElement.__member(2), StdVideoDecodeH264MvcElement.__array(2, 15));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        VIEWORDERINDEX = layout.offsetof(1);
        VIEWID = layout.offsetof(2);
        TEMPORALID = layout.offsetof(3);
        PRIORITYID = layout.offsetof(4);
        NUMOFANCHORREFSINL0 = layout.offsetof(5);
        VIEWIDOFANCHORREFSINL0 = layout.offsetof(6);
        NUMOFANCHORREFSINL1 = layout.offsetof(7);
        VIEWIDOFANCHORREFSINL1 = layout.offsetof(8);
        NUMOFNONANCHORREFSINL0 = layout.offsetof(9);
        VIEWIDOFNONANCHORREFSINL0 = layout.offsetof(10);
        NUMOFNONANCHORREFSINL1 = layout.offsetof(11);
        VIEWIDOFNONANCHORREFSINL1 = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH264MvcElement, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH264MvcElement ELEMENT_FACTORY = StdVideoDecodeH264MvcElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoDecodeH264MvcElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoDecodeH264MvcElementFlags flags() {
            return StdVideoDecodeH264MvcElement.nflags(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewOrderIndex() {
            return StdVideoDecodeH264MvcElement.nviewOrderIndex(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewId() {
            return StdVideoDecodeH264MvcElement.nviewId(this.address());
        }

        @NativeType(value="uint16_t")
        public short temporalId() {
            return StdVideoDecodeH264MvcElement.ntemporalId(this.address());
        }

        @NativeType(value="uint16_t")
        public short priorityId() {
            return StdVideoDecodeH264MvcElement.npriorityId(this.address());
        }

        @NativeType(value="uint16_t")
        public short numOfAnchorRefsInL0() {
            return StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL0(this.address());
        }

        @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
        public ShortBuffer viewIdOfAnchorRefsInL0() {
            return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewIdOfAnchorRefsInL0(int index) {
            return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), index);
        }

        @NativeType(value="uint16_t")
        public short numOfAnchorRefsInL1() {
            return StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL1(this.address());
        }

        @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
        public ShortBuffer viewIdOfAnchorRefsInL1() {
            return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewIdOfAnchorRefsInL1(int index) {
            return StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), index);
        }

        @NativeType(value="uint16_t")
        public short numOfNonAnchorRefsInL0() {
            return StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL0(this.address());
        }

        @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
        public ShortBuffer viewIdOfNonAnchorRefsInL0() {
            return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewIdOfNonAnchorRefsInL0(int index) {
            return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), index);
        }

        @NativeType(value="uint16_t")
        public short numOfNonAnchorRefsInL1() {
            return StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL1(this.address());
        }

        @NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]")
        public ShortBuffer viewIdOfNonAnchorRefsInL1() {
            return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address());
        }

        @NativeType(value="uint16_t")
        public short viewIdOfNonAnchorRefsInL1(int index) {
            return StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), index);
        }

        public Buffer flags(StdVideoDecodeH264MvcElementFlags value) {
            StdVideoDecodeH264MvcElement.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH264MvcElementFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer viewOrderIndex(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewOrderIndex(this.address(), value);
            return this;
        }

        public Buffer viewId(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewId(this.address(), value);
            return this;
        }

        public Buffer temporalId(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.ntemporalId(this.address(), value);
            return this;
        }

        public Buffer priorityId(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.npriorityId(this.address(), value);
            return this;
        }

        public Buffer numOfAnchorRefsInL0(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL0(this.address(), value);
            return this;
        }

        public Buffer viewIdOfAnchorRefsInL0(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
            StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), value);
            return this;
        }

        public Buffer viewIdOfAnchorRefsInL0(int index, @NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL0(this.address(), index, value);
            return this;
        }

        public Buffer numOfAnchorRefsInL1(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nnumOfAnchorRefsInL1(this.address(), value);
            return this;
        }

        public Buffer viewIdOfAnchorRefsInL1(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
            StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), value);
            return this;
        }

        public Buffer viewIdOfAnchorRefsInL1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewIdOfAnchorRefsInL1(this.address(), index, value);
            return this;
        }

        public Buffer numOfNonAnchorRefsInL0(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL0(this.address(), value);
            return this;
        }

        public Buffer viewIdOfNonAnchorRefsInL0(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
            StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), value);
            return this;
        }

        public Buffer viewIdOfNonAnchorRefsInL0(int index, @NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL0(this.address(), index, value);
            return this;
        }

        public Buffer numOfNonAnchorRefsInL1(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nnumOfNonAnchorRefsInL1(this.address(), value);
            return this;
        }

        public Buffer viewIdOfNonAnchorRefsInL1(@NativeType(value="uint16_t[STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE]") ShortBuffer value) {
            StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), value);
            return this;
        }

        public Buffer viewIdOfNonAnchorRefsInL1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264MvcElement.nviewIdOfNonAnchorRefsInL1(this.address(), index, value);
            return this;
        }
    }
}

