/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264PictureInfoFlags;

public class StdVideoEncodeH264PictureInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PICTURETYPE;
    public static final int FRAME_NUM;
    public static final int PICORDERCNT;

    public StdVideoEncodeH264PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH264PictureInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264PictureInfoFlags flags() {
        return StdVideoEncodeH264PictureInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoH264PictureType")
    public int pictureType() {
        return StdVideoEncodeH264PictureInfo.npictureType(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_num() {
        return StdVideoEncodeH264PictureInfo.nframe_num(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt() {
        return StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address());
    }

    public StdVideoEncodeH264PictureInfo flags(StdVideoEncodeH264PictureInfoFlags value) {
        StdVideoEncodeH264PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo flags(Consumer<StdVideoEncodeH264PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264PictureInfo pictureType(@NativeType(value="StdVideoH264PictureType") int value) {
        StdVideoEncodeH264PictureInfo.npictureType(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo frame_num(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264PictureInfo.nframe_num(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo PicOrderCnt(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo set(StdVideoEncodeH264PictureInfoFlags flags, int pictureType, int frame_num, int PicOrderCnt) {
        this.flags(flags);
        this.pictureType(pictureType);
        this.frame_num(frame_num);
        this.PicOrderCnt(PicOrderCnt);
        return this;
    }

    public StdVideoEncodeH264PictureInfo set(StdVideoEncodeH264PictureInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264PictureInfo malloc() {
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoEncodeH264PictureInfo calloc() {
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoEncodeH264PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH264PictureInfo create(long address) {
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, address);
    }

    @Nullable
    public static StdVideoEncodeH264PictureInfo createSafe(long address) {
        return address == 0L ? null : StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoEncodeH264PictureInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264PictureInfo.__create(capacity, SIZEOF);
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoEncodeH264PictureInfo.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoEncodeH264PictureInfo malloc(MemoryStack stack) {
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoEncodeH264PictureInfo calloc(MemoryStack stack) {
        return StdVideoEncodeH264PictureInfo.wrap(StdVideoEncodeH264PictureInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH264PictureInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264PictureInfoFlags nflags(long struct) {
        return StdVideoEncodeH264PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static int npictureType(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICTURETYPE);
    }

    public static int nframe_num(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_NUM);
    }

    public static int nPicOrderCnt(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT);
    }

    public static void nflags(long struct, StdVideoEncodeH264PictureInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH264PictureInfoFlags.SIZEOF);
    }

    public static void npictureType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICTURETYPE, value);
    }

    public static void nframe_num(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_NUM, value);
    }

    public static void nPicOrderCnt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264PictureInfo.__struct(StdVideoEncodeH264PictureInfo.__member(StdVideoEncodeH264PictureInfoFlags.SIZEOF, StdVideoEncodeH264PictureInfoFlags.ALIGNOF), StdVideoEncodeH264PictureInfo.__member(4), StdVideoEncodeH264PictureInfo.__member(4), StdVideoEncodeH264PictureInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PICTURETYPE = layout.offsetof(1);
        FRAME_NUM = layout.offsetof(2);
        PICORDERCNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264PictureInfo ELEMENT_FACTORY = StdVideoEncodeH264PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoEncodeH264PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264PictureInfoFlags flags() {
            return StdVideoEncodeH264PictureInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoH264PictureType")
        public int pictureType() {
            return StdVideoEncodeH264PictureInfo.npictureType(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_num() {
            return StdVideoEncodeH264PictureInfo.nframe_num(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt() {
            return StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address());
        }

        public Buffer flags(StdVideoEncodeH264PictureInfoFlags value) {
            StdVideoEncodeH264PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer pictureType(@NativeType(value="StdVideoH264PictureType") int value) {
            StdVideoEncodeH264PictureInfo.npictureType(this.address(), value);
            return this;
        }

        public Buffer frame_num(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264PictureInfo.nframe_num(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address(), value);
            return this;
        }
    }
}

