/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoH264ScalingLists
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SCALING_LIST_PRESENT_MASK;
    public static final int USE_DEFAULT_SCALING_MATRIX_MASK;
    public static final int SCALINGLIST4X4;
    public static final int SCALINGLIST8X8;

    public StdVideoH264ScalingLists(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoH264ScalingLists.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte scaling_list_present_mask() {
        return StdVideoH264ScalingLists.nscaling_list_present_mask(this.address());
    }

    @NativeType(value="uint8_t")
    public byte use_default_scaling_matrix_mask() {
        return StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]")
    public ByteBuffer ScalingList4x4() {
        return StdVideoH264ScalingLists.nScalingList4x4(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList4x4(int index) {
        return StdVideoH264ScalingLists.nScalingList4x4(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]")
    public ByteBuffer ScalingList8x8() {
        return StdVideoH264ScalingLists.nScalingList8x8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList8x8(int index) {
        return StdVideoH264ScalingLists.nScalingList8x8(this.address(), index);
    }

    public StdVideoH264ScalingLists scaling_list_present_mask(@NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nscaling_list_present_mask(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists use_default_scaling_matrix_mask(@NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH264ScalingLists.nScalingList4x4(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nScalingList4x4(this.address(), index, value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH264ScalingLists.nScalingList8x8(this.address(), value);
        return this;
    }

    public StdVideoH264ScalingLists ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH264ScalingLists.nScalingList8x8(this.address(), index, value);
        return this;
    }

    public StdVideoH264ScalingLists set(byte scaling_list_present_mask, byte use_default_scaling_matrix_mask, ByteBuffer ScalingList4x4, ByteBuffer ScalingList8x8) {
        this.scaling_list_present_mask(scaling_list_present_mask);
        this.use_default_scaling_matrix_mask(use_default_scaling_matrix_mask);
        this.ScalingList4x4(ScalingList4x4);
        this.ScalingList8x8(ScalingList8x8);
        return this;
    }

    public StdVideoH264ScalingLists set(StdVideoH264ScalingLists src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoH264ScalingLists malloc() {
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoH264ScalingLists calloc() {
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoH264ScalingLists create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoH264ScalingLists create(long address) {
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, address);
    }

    @Nullable
    public static StdVideoH264ScalingLists createSafe(long address) {
        return address == 0L ? null : StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoH264ScalingLists.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoH264ScalingLists.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoH264ScalingLists.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH264ScalingLists.__create(capacity, SIZEOF);
        return StdVideoH264ScalingLists.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoH264ScalingLists.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoH264ScalingLists.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoH264ScalingLists malloc(MemoryStack stack) {
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoH264ScalingLists calloc(MemoryStack stack) {
        return StdVideoH264ScalingLists.wrap(StdVideoH264ScalingLists.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoH264ScalingLists.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoH264ScalingLists.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nscaling_list_present_mask(long struct) {
        return UNSAFE.getByte(null, struct + (long)SCALING_LIST_PRESENT_MASK);
    }

    public static byte nuse_default_scaling_matrix_mask(long struct) {
        return UNSAFE.getByte(null, struct + (long)USE_DEFAULT_SCALING_MATRIX_MASK);
    }

    public static ByteBuffer nScalingList4x4(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST4X4, 16);
    }

    public static byte nScalingList4x4(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST4X4 + Checks.check(index, 16) * 1L);
    }

    public static ByteBuffer nScalingList8x8(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST8X8, 64);
    }

    public static byte nScalingList8x8(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST8X8 + Checks.check(index, 64) * 1L);
    }

    public static void nscaling_list_present_mask(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALING_LIST_PRESENT_MASK, value);
    }

    public static void nuse_default_scaling_matrix_mask(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)USE_DEFAULT_SCALING_MATRIX_MASK, value);
    }

    public static void nScalingList4x4(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST4X4, value.remaining() * 1);
    }

    public static void nScalingList4x4(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST4X4 + Checks.check(index, 16) * 1L, value);
    }

    public static void nScalingList8x8(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST8X8, value.remaining() * 1);
    }

    public static void nScalingList8x8(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST8X8 + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoH264ScalingLists.__struct(StdVideoH264ScalingLists.__member(1), StdVideoH264ScalingLists.__member(1), StdVideoH264ScalingLists.__array(1, 16), StdVideoH264ScalingLists.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SCALING_LIST_PRESENT_MASK = layout.offsetof(0);
        USE_DEFAULT_SCALING_MATRIX_MASK = layout.offsetof(1);
        SCALINGLIST4X4 = layout.offsetof(2);
        SCALINGLIST8X8 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH264ScalingLists, Buffer>
    implements NativeResource {
        private static final StdVideoH264ScalingLists ELEMENT_FACTORY = StdVideoH264ScalingLists.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoH264ScalingLists getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte scaling_list_present_mask() {
            return StdVideoH264ScalingLists.nscaling_list_present_mask(this.address());
        }

        @NativeType(value="uint8_t")
        public byte use_default_scaling_matrix_mask() {
            return StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]")
        public ByteBuffer ScalingList4x4() {
            return StdVideoH264ScalingLists.nScalingList4x4(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList4x4(int index) {
            return StdVideoH264ScalingLists.nScalingList4x4(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]")
        public ByteBuffer ScalingList8x8() {
            return StdVideoH264ScalingLists.nScalingList8x8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList8x8(int index) {
            return StdVideoH264ScalingLists.nScalingList8x8(this.address(), index);
        }

        public Buffer scaling_list_present_mask(@NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nscaling_list_present_mask(this.address(), value);
            return this;
        }

        public Buffer use_default_scaling_matrix_mask(@NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nuse_default_scaling_matrix_mask(this.address(), value);
            return this;
        }

        public Buffer ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH264ScalingLists.nScalingList4x4(this.address(), value);
            return this;
        }

        public Buffer ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nScalingList4x4(this.address(), index, value);
            return this;
        }

        public Buffer ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH264ScalingLists.nScalingList8x8(this.address(), value);
            return this;
        }

        public Buffer ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH264ScalingLists.nScalingList8x8(this.address(), index, value);
            return this;
        }
    }
}

