var demoNumber = 1;

const demoTitles = ['', 'Numen / Taquart, 2002', 'Boogie Nights / Lamers, 2012', 'Perestroyka / USSR, 1989'];

document.addEventListener("DOMContentLoaded", function() {  

    // Function to set the image source based on the demo number
    function setImageSource(demoNumber) {
        
        let nextDemoNumber = parseInt(demoNumber, 10);
        nextDemoNumber = nextDemoNumber.toString().padStart(2, '0');
        
        const imgSrc = `img/image_d_${nextDemoNumber}.png`;

        // Get the canvas element and its context
        const canvas = document.getElementById("canvas");
        const ctx = canvas.getContext("2d");

        // Load the image
        const img = new Image();
        img.src = imgSrc;

        // Draw the image on the canvas when it loads
        img.onload = function() {
            ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the canvas
            ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
        };
        
        // Show title
        const title = document.getElementById("demoTitle");
        title.style.opacity = "0";
        title.innerHTML = '&nbsp;';
    }

    // Initial image load
    setImageSource(demoNumber);

    // Get the overlay element
    const overlay = document.getElementById("overlay");

    // Function to create 25 div elements for the overlay
    function createOverlaySquares() {
        overlay.innerHTML = ''; // Clear existing squares
        for (let i = 0; i < 25; i++) {
            const rect = document.createElement("div");
            rect.id = "rect" + (i + 1);
            overlay.appendChild(rect);
        }
    }

    createOverlaySquares(); // Initial creation of squares

    // Set to track revealed squares
    let revealedSquares = new Set();

    // Function to reveal a random square
    function revealRandomSquare() {
        if (revealedSquares.size >= 25) {
            alert("All squares have been revealed!");
            return;
        }

        let randomIndex;
        do {
            randomIndex = Math.floor(Math.random() * 25) + 1;
        } while (revealedSquares.has(randomIndex));

        revealedSquares.add(randomIndex);
        const randomRect = document.getElementById("rect" + randomIndex);
        randomRect.style.opacity = "0";
    }
    
    function revealAll() {
        for (let i = 1; i <= 25; i++) {
            const rect = document.getElementById("rect" + i);
            rect.style.opacity = "0";
        }
        const title = document.getElementById("demoTitle");
        title.style.opacity = "1";
        title.innerHTML = demoTitles[demoNumber];
    }

    // Add event listener to the reveal button
    const revealButton = document.getElementById("revealButton");
    revealButton.addEventListener("click", revealRandomSquare);

    // Function to navigate to the next demo
    function goToNextDemo() {
        
        const title = document.getElementById("demoTitle");
        title.innerHTML = '';
        
        demoNumber++;

        if (demoNumber > 3) {
            alert("No more demos available!");
            return;
        }
        nextDemoNumber = demoNumber.toString().padStart(2, '0');  // Ensure two digits

        // Reset the overlay squares
        createOverlaySquares();

        // Reset revealed squares set
        revealedSquares = new Set();

        // Set the new image source
        setImageSource(nextDemoNumber);

    }
    
    

    // Add event listener to the next demo button
    const nextDemoButton = document.getElementById("nextDemoButton");
    nextDemoButton.addEventListener("click", goToNextDemo);
    
    const revealAllButton = document.getElementById("revealAllButton");
    revealAllButton.addEventListener("click", revealAll);
});
