   DEVICE ZXSPECTRUM48

    org 0x8000
start    
    ld b, 0x10
repeatsprite
    ld a, b
    ld hl, pixelart
    ld de, pixelart + 16
    ld bc, 0x0010
    ldir
    ld b, a
    djnz repeatsprite
    
    ld hl, pixelart    ; Load the address of the 16-bit word into HL
    ld de, pixelart + 16
    ld b, 96
spriteroll
    ld a, (hl)         ; Load the low byte of the word into register A
    rrc a              ; Rotate the low byte left through carry (1 bit)
    res 7, a
    ld (de), a         ; Store the rotated low byte back into memory
    inc hl             ; Move to the next memory location (high byte)
    inc de
    ld a, (hl)         ; Load the high byte of the word into register A
    rra                ; Rotate the high byte left through carry (1 bit)
    ld (de), a         ; Store the rotated high byte back into memory
    inc hl
    inc de
    djnz spriteroll
loop
    ld a, (de)
    add a, 16
    and 0x7f
    ld (de), a
    ld d, 0x40
    ld hl, pixelart
    add a, l
    ld l, a
    call fill2
    call fill2
    ld bc, 0x0020
    ld hl, (0x7002)
    add hl, bc
    ld (0x7002), hl
    ld e, h
    call delay
    jr loop
fill2
    call fill
    call fill
    call fill
    call fill
    ret
fill
    ldi
    ldi
    inc d
    dec e
    dec e
    ret
delay
    ld a,(hl)
    and 0b00010000
    out (254),a
    ld bc, 4000   ; Set delay loop count (adjust for desired beep duration)
delay_loop
    dec bc         ; Decrement loop count
    ld a, b        ; Load high byte of loop count
    or c           ; Logical OR with low byte of loop count
    jr nz, delay_loop  ; If loop count not zero, continue delay
    xor a
    out (254),a
    ret            ; Return from subroutine
pixelart
   db 0b00000000, 0b00000000
   db 0b10000100, 0b00000000
   db 0b01111000, 0b00000000
   db 0b10110100, 0b00000000
   db 0b11001100, 0b00000000
   db 0b11001110, 0b00000000
   db 0b11111110, 0b00000000
   db 0b11111100
end


    display /d,end-start
    savebin "intro2.bin",start,end-start
    savesna "intro2.sna",start  