//------------------------------------
// "hell awaits"
// 512b intro
// by wacek/arise
//------------------------------------

//------------------------------------
// global compile variables
//------------------------------------

.var screen = $0400

.var screen_08 = $25 
.var screen_0c = $35
.var screen_30 = $c5

.var temp = $a0
.var frame = $a1

.var big_cross_to = $a2 // + $a3

.var sid_table_2 = $ecac  

//------------------------------------
// main
//------------------------------------

			* = $1000	"main"
		
start:		sei

			ror $d011

			lda #$02
			sta $0286
			jsr $e544

build_big_cross_table:
			
!loop:		lda bct_lo_08_0 - 1,y
			sta $3fff,y
			lda bct_hi_08_0 - 1,y
			sta $4fff,y
			dey
			bne !loop-

			sty $d021
			sty $d020

			clc

!bloop:		ldx #0
!loop:		lda bbc_here1: $4000,x
			adc #40
			sta bbc_here2: $4100,x
			lda bbc_here3: $5000,x
			adc #0
			sta bbc_here4: $5100,x
			inx
			bne !loop-

			inc bbc_here1 + 1
			inc bbc_here2 + 1
			inc bbc_here3 + 1
			inc bbc_here4 + 1
			
			lda sid_table,y
			sta $d408,y
			lda sid_table_2,y			
			sta $d417,y			
						
			iny
			cpy #13
			bne !bloop-

			lda #$51
			sta $d412
			sta $d40b

			jsr do_row_of_crosses
			
			jsr do_copy_row
			jsr do_transfer_screen_04_20
			
			lda #<small_cross_2_1
			sta dsc_tab
			lda #>small_cross_2_1
			sta dsc_tab + 1
			lda #$62
			sta dsc_char
			lda #$0
			sta frame
			sta sc_target
			
			jsr do_row_of_crosses

			lda #<small_cross_2_2
			sta dsc_tab
			lda #>small_cross_2_2
			sta dsc_tab + 1
			lda #$e2
			sta dsc_char

			jsr do_row_of_crosses
			jsr do_copy_row
			ldx #>screen		
			lda #$28
			jsr do_transfer_screen

			rol $d011

			bcc first_start
			
main_loop:	jsr wait

			lda #screen_30
			sta $d018

first_start:

			ldx frame

			lda frame_tab,x
			sta dts_from
			ldx #$20
			lda #$08
			jsr do_transfer_screen

			jsr do_big_cross_screen
			
			jsr wait

			lda #screen_08
			sta $d018
			
			ldx #$28
			lda #$30
			jsr do_transfer_screen
			
			jsr do_big_cross_screen
			
			inc frame
			lda frame
			sta $d416
			cmp #6
			bne main_loop
			
			lda #0
			sta frame
			
			jmp main_loop


frame_tab:	.byte $c8,$a0,$78,$50,$28,$00

//--------------------------------------------

do_big_cross:
			// a = hi
			// x = lo

			stx big_cross_to
			sta big_cross_to + 1
			ldx #14
!loop:		lda big_cross_tab_1,x
			tay
			lda big_cross_chars_1,x
			sta (big_cross_to),y
			dex
			bne !loop-
!skip:		inc big_cross_to + 1
			ldx #10
!loop:		lda big_cross_tab_2,x
			tay
			lda big_cross_chars_2,x
			sta (big_cross_to),y
			dex
			bne !loop-
big_cross_tab_1:
			rts

			.byte 84,85,124,125,164,165,204,205
			.byte 242,243,244,245,246
big_cross_tab_2:
			.byte 247
			.byte 26,27,28,29,30,31
			.byte 68,69,108
big_cross_chars_1:
			.byte 109
			.byte $cf,$d0,$f4,$ea,$f4,$ea,$f4,$ea
			.byte $cf,$f7,$a0,$a0,$f7
big_cross_chars_2:			
			.byte $d0
			.byte $cc,$ef,$a0,$a0,$ef,$fa
			.byte $f4,$ea,$cc,$fa

bct_hi_08_0:	
			.byte $06,$06,$06,$06,$08,$08,$08,$08
			.byte $09,$09,$09,$09

bct_lo_08_0:	
			.byte $20,$2a,$34,$3e,$00,$0a,$14,$1e
			.byte $e0,$ea,$f4,$fe

//--------------------------------------------
// procedures
//--------------------------------------------

do_big_cross_screen:
			
			clc
!loop:		sty temp
			lda dbc_tab1: $4000,y
			tax
			lda dbc_tab2: $5000,y
			adc dbc_mod: #$0
			jsr do_big_cross
			ldy temp
			iny
			cpy #12
			bne !loop-
			
			lda dbc_mod
			eor #$28
			sta dbc_mod
			
			inc dbc_tab1 + 1
			inc dbc_tab2 + 1
			lda dbc_tab1 + 1
			cmp #$4c
			bne !skip+
			
			lda #$40
			sta dbc_tab1 + 1
			lda #$50
			sta dbc_tab2 + 1

!skip:		rts

//--------------------------------------------

do_transfer_screen:
			// x = from
			// a = to
			stx dts_from + 1
			sta dts_to + 1
do_transfer_screen_04_20:
			ldy dts_how_many: #5
!bloop:		ldx #0
!loop:		lda dts_from: screen,x
			sta dts_to:   $2000,x
			inx
			bne !loop-
			inc dts_from + 1
			inc dts_to + 1
			dey
			bne !bloop- 
			rts

//--------------------------------------------

do_copy_row:
			// copy 1 row of small crosses
			// to 5 rows

!loop:		lda screen,x
			sta screen + 1 * 240,x
			sta screen + 2 * 240,x
			sta screen + 3 * 240,x
			sta screen + 4 * 240,x
			
			inx
			bne !loop-
			rts

//--------------------------------------------
		
do_row_of_crosses:
			clc
			ldy #8
!bloop:		lda #0
			sta temp

!loop:		ldx temp
			lda dsc_tab: small_cross,x
			beq !skip+
			tax
			lda dsc_char: #$a0
			sta sc_target: screen,x
			inc temp
			bne !loop-
!skip:		

			lda sc_target
			adc #5
			sta sc_target
			dey			
			bne !bloop-			
			rts		

//------------------------------------
// global tables
//------------------------------------

small_cross:
			.byte 42,82,122

small_cross_2_2:
			.byte 121,123,162,0

small_cross_2_1:
			.byte 42,121,123,0

//------------------------------------
// global procedures
//------------------------------------

			// a classic wait
			
wait:		bit $d011
			bpl *-3
			bit $d011
			bmi *-3
			rts

//------------------------------------
// sound design data
//------------------------------------

sid_table:	.byte $04 // 01: $d408 - freq hi byte
			.byte $80 // 02: $d409 - pulse lo
			.byte $88 // 03: $d40a - pulse hi
			.byte $20 // 04: $d40b - waveform
			.byte $ff // 04: $d40c - ad
			.byte $ff // 00: $d40d - sr
			.byte $2d // 01: $d40e - freq lo byte
			.byte $02 // 02: $d40f - freq hi byte
			.byte $ff // 03: $d410 - pulse lo
			.byte $88 // 04: $d411 - pulse hi
			.byte $40 // 05: $d412 - waveform
			.byte $ff // 06: $d413 - ad
			.byte $ff // 07: $d414 - sr

//------------------------------------
// all ends here
//------------------------------------