;; RAINBOW FLASH / hannu
;; 8 byte intro for 8088 (or 86Box or Dosbox-X)
;; Lovebyte 2024
;;
;; Greets to all sizecoders!

S:
 les ax,[si]
 rep stosb
 es movsb
 jmp S+1

;; How it works:
;
; 00000100  C404              les ax,[si]
; 00000102  F3AA              rep stosb
; 00000104  26A4              es movsb
; 00000106  EBF9              jmp short 0x101
;
; 1. The LES instruction loads the 16-bit value at address 0x102 into the ES
; segment register. That's 0xAAF3, which is slightly under 0xB000, where
; textmode screen memory resides.
;
; 2. REP STOSB repeatedly writes the value in AX into ES:DI, effectively just
; modifying DI value at this point.
;
; 3. ES MOVSB copies a byte from ES:SI to ES:DI, doing a primitive feedback
; effect.
;
; 4. JMP short 0x101 jumps to another interpretation of the same code:
;
; 00000100  skipping 0x1 bytes
; 00000101  04F3              add al,0xf3
; 00000103  AA                stosb
;
; 5. Then we do the add al - stosb - es movsb loop and get a nice pattern :)
