include "hardware.inc"

def btnA            equ 0
def btnB            equ 1
def btnSelect       equ 2
def btnStart        equ 3
def btnRight        equ 4
def btnLeft         equ 5
def btnUp           equ 6
def btnDown         equ 7

section "HRAM",hram
CurrentRow: dw
RNG:        db
PlayerXP:   db
RowPos:     db

def PlayerY     = $fe00
def PlayerX     = $fe01
def PlayerTile  = $fe02

section "Program code",rom0[$0040]
VBlank: reti

Start:
    di
    xor     a
    ldh     [rLCDC],a    
    ldh     [CurrentRow],a
    ldh     [CurrentRow+1],a
    
    ld      hl,$fe00
    ld      b,a
:   ld      [hl],a
    inc     l ; can't do ld [hl+],a because of the OAM corruption bug, so ld [hl],a / inc l has to do :(
    dec     b
    jr      nz,:-
    
    ld      [hl],$8f
    
    ld      hl,_VRAM + 16
    ld      b,16
:   call    RandomNumber
    ld      [hl+],a
    dec     b
    jr      nz,:-
    ld      a,1
    ld      [PlayerTile],a
    ld      a,16
    ld      [PlayerY],a
    
    ; prepare background map
    ld      bc,16 << 8 | 64
    xor     a
    ld      hl,_SCRN0
:   ld      [hl+],a
    dec     b
    jr      nz,:-
    xor     1
    ld      b,16
    dec     c
    jr      nz,:-
    ld      a,-16
    ldh     [rSCX],a
    ldh     [rBGP],a
    rra
    ldh     [rOBP0],a
    
    ld      a,LCDCF_ON | LCDCF_BGON | LCDCF_BLK01 | LCDCF_OBJON
    ldh     [rLCDC],a
    
    ld      a,IEF_VBLANK
    ldh     [rIE],a
    ei
MainLoop:
    halt
    call    DoPlayer
    jr      z,:+
    ld      hl,rBGP
    ld      a,[hl]
    cpl
    ld      [hl+],a
    ld      [hl],a
    jr      @
:   ld      hl,CurrentRow
    inc     [hl]
    ld      a,[hl]
    add     8
    ldh     [rSCY],a
    sub     8
    and     $3f
    ld      b,a
    and     a
    jr      nz,MainLoop
    inc     l
    inc     [hl]
    ld      a,[hl]
    and     3
    ld      [RowPos],a
    ld      h,a
    ld      l,0
    
    ld      de,_SCRN0
    add     hl,de
    ld      de,8 << 8 | 2
    call    RandomNumber
:   rra
    ld      [hl],0
    jr      c,:+
    ld      [hl],1
:   inc     l
    dec     d
    jr      nz,:--
    ld      d,8
    call    RandomNumber
    dec     e
    jr      nz,:--    
    jr      MainLoop

RandomNumber:
    push    hl
    ld      hl,RNG
    ld      a,[hl]
    ld      c,a
    add     a
    add     c
    add     a
    add     a
    add     c
    add     83
    ld      [hl],a
    pop     hl
    ret
    
PlayerL:
    ld      hl,PlayerXP
    dec     [hl]
    dec     [hl]
    bit     7,[hl]
    ret     z
    ld      [hl],0
    ret
    
PlayerR:
    ld      hl,PlayerXP
    inc     [hl]
    inc     [hl]
    bit     7,[hl]
    ret     z
    ld      [hl],$7f
    ret

section "ROM header",rom0[$100]
    jp Start
    nop
NintendoLogo:
    ds  48,0
    
    ds  $150-@,0

section "Extra space",rom0[$0003]
    
DoPlayer:
    ld      hl,rP1
    ld      [hl],P1F_5
    ld      e,[hl]
    
    bit     0,e
    call    nz,PlayerL
    bit     1,e
    call    nz,PlayerR
    ld      a,[hl]
    add     $14
    ld      [PlayerX],a
    ldh     a,[rSCY]
    add     8
    and     $f8
    ld      l,a
    ld      h,0
    add     hl,hl
    add     hl,hl
    ld      a,[PlayerXP]
    rra
    rra
    rra
    and     $f
    add     l
    ld      l,a
    jr      nc,:+
    inc     h
:
    ld      de,_SCRN0
    add     hl,de
    ld      a,[hl]
    and     a
    ret

    db  "FreeStip"

section "NO ENTRY",rom0[$0150]
Reserved:   ds  $3fff-@,0