include "hardware.inc"

def btnA            equ 0
def btnB            equ 1
def btnSelect       equ 2
def btnStart        equ 3
def btnRight        equ 4
def btnLeft         equ 5
def btnUp           equ 6
def btnDown         equ 7

section "HRAM",hram
CurrentTick:    dw ; counts up by 1 each frame
RNG:            db ; RNG seed
PlayerXP:       db ; player X position
NumRows:        db

def PlayerY     = $fe00 ; player sprite Y position - offset down by 16 pixels
def PlayerX     = $fe01 ; player sprite X position - offset right by 20 pixels
def PlayerTile  = $fe02 ; player sprite tile

section "Program code",rom0[$0040]
VBlank: reti

Start:
    di
    xor     a
    ldh     [rLCDC],a    
    ldh     [CurrentTick],a
    ldh     [CurrentTick+1],a
    
    ld      hl,$fe00
    ld      b,a
:   ld      [hl],a
    inc     l ; can't do ld [hl+],a because of the OAM corruption bug, so ld [hl],a / inc l has to do :(
    dec     b
    jr      nz,:-
    
    ld      [hl],$8f
    
    ld      hl,_VRAM + 16
    ld      b,16
:   call    RandomNumber
    ld      [hl+],a
    dec     b
    jr      nz,:-
    ld      a,1
    ld      [PlayerTile],a
    ld      a,16
    ld      [PlayerY],a
    
    ; prepare background map
    ; repeating pattern of 16x $00 then 16x $01
    ld      bc,16 << 8 | 64
    xor     a
    ld      hl,_SCRN0
:   ld      [hl+],a
    dec     b
    jr      nz,:-
    xor     1
    ld      b,16
    dec     c
    jr      nz,:-
    ld      a,-16
    ldh     [rSCX],a    ; offset screen 16 pixels to the left to center everything
    ldh     [rBGP],a    ; reuse screen offset for background palette
    rra                 ; a single bitshift gives us four shades of gray at the cost of 1 byte
    ldh     [rOBP0],a   ; use it to differentiate the player from the rocks
    
    ld      a,LCDCF_ON | LCDCF_BGON | LCDCF_BLK01 | LCDCF_OBJON
    ldh     [rLCDC],a
    
    ld      a,IEF_VBLANK
    ldh     [rIE],a
    ei
MainLoop:
    halt
    call    DoPlayer
    jr      z,:+    ; if we didn't hit a rock, jump ahead
    ; if we DID hit a rock, invert the screen
    ld      hl,rBGP
    ld      a,[hl]
    cpl
    ld      [hl+],a
    ld      a,[hl]
    cpl
    ld      [hl],a
    jr      @   ; loop forever
:   ; scroll screen
    ld      hl,CurrentTick
    inc     [hl]
    ld      a,[hl]
    add     8
    ldh     [rSCY],a
    sub     8
    and     $3f
    ld      b,a
    and     a
    jr      nz,MainLoop
    ; generate new rocks
    inc     l
    inc     [hl]
    ld      a,[hl]
    and     3
    ld      [NumRows],a
    ld      h,a
    ld      l,0
    ld      de,_SCRN0
    add     hl,de
    ld      de,8 << 8 | 2
    call    RandomNumber
:   rra
    ld      [hl],0
    jr      c,:+
    ld      [hl],1
:   inc     l
    dec     d
    jr      nz,:--
    ld      d,8
    call    RandomNumber
    dec     e
    jr      nz,:--    
    jr      MainLoop

; sourced from https://learn.cemetech.net/index.php/Z80:Math_Routines#rand8_LCG
RandomNumber:
    ldh     a,[RNG]
    ld      c,a
    add     a
    add     c
    add     a
    add     a
    add     c
    add     83
    ldh     [RNG],a
    ret

; move player left
PlayerL:
    ld      hl,PlayerXP
    dec     [hl]
    dec     [hl]
    bit     7,[hl]
    ret     z
    ld      [hl],0
    ret

; move player right
PlayerR:
    ld      hl,PlayerXP
    inc     [hl]
    inc     [hl]
    bit     7,[hl]
    ret     z
    ld      [hl],$7f
    ret

section "ROM header",rom0[$100]
    jp Start
    nop
NintendoLogo:
    ds  48,0
    
    ds  $150-@,0

section "Extra emergency space",rom0[$0003]
    
DoPlayer:
    ; read D-pad input
    ; normally we'd want to do multiple dummy reads to avoid bouncing, but we don't need to worry about that here since we only need to check held inputs
    ld      hl,rP1
    ld      [hl],P1F_5
    ld      e,[hl]
    
    ; movement
    bit     0,e
    call    nz,PlayerL
    bit     1,e
    call    nz,PlayerR
    ld      a,[hl]
    ; offset for sprite X pos
    add     $14
    ld      [PlayerX],a
    ; check if we're colliding with a rock
    ldh     a,[rSCY]
    add     8
    and     $f8
    ld      l,a
    ld      h,0
    add     hl,hl
    add     hl,hl
    ld      a,[PlayerXP]
    rra
    rra
    rra
    and     $f
    add     l
    ld      l,a
    jr      nc,:+
    inc     h
:   ld      de,_SCRN0
    add     hl,de
    ld      a,[hl]
    and     a ; z = no collision, nz = collision
    ret

; we have some extra space to fill here, so here's a fun little shoutout :P
    db  "karma"

section "NO ENTRY",rom0[$0150]
Reserved:   ds  $3fff-@,0