;===============================================================================
; Blockout255
; a c64 nanogame which is a mini breakout in less than 256 bytes
;
; by Wil, Pararaum and Logiker
; presented at Lovebyte 2024
;===============================================================================

.include "LAMAlib.inc"

.MACPACK cbm
.MACPACK longbranch

;-------------------------------------------------------------------------------
; constants
;
DELAY      =8
START_POS_X=20
START_POS_Y=20
MIN_X=0
MAX_X=37
MIN_Y=15
MAX_Y=23
BLOCKS2HIT=57

ADD_OLD_ROM_FIX=1	;0 is shortest, but doesn't display paddle and ball on older C64s
			;1 is a fix that costs 6 bytes, on older C64s paddle and ball will be displayed in green instead of light blue
			;2 is a fix that costs 6 bytes, paddle and ball are displayed in light blue on all C64s

;LINENUMBER is a 16 bit value and is the line number of the BASIC SYS line
;the BASIC interpreter copies the value into ZP addresses $39 and $3a
;hibyte should be $20 because it is the level2_flag

LINENUMBER=$2020

;-------------------------------------------------------------------------------
; zero page address labels
;
	.zeropage
ballx		= $23
bally		= $22
balldx:		.res	1
balldy:		.res	1
paddlex		= $B9
paddley		= $BA
delayctr:	.res	1
blockcounter:	.res	1
level2_flag	= $39		;address $ff is initialized with $20 upon start, $20 = level 1, $e6 = level 2+
after_hit_tile  = $81		;contains $20, part of CHRGET routine comparing for a space!


	.code
;-------------------------------------------------------------------------------
; memory address labels
;
SOUNDSRC   	= $e2dd	;a good pattern in ROM to set the SID registers
SCREEN_BASE	= $400
SYSTARGET	= $80b	;address of gamestart, but needs to be given as a constant here

;-------------------------------------------------------------------------------
; ROM routines

PLOT_WITH_CLC	= $e50c
PRINT_STARTUP_MSG = $e422		; Print startup screen. Sets A to 0, X to FA
INIT_CHRGET 	= $E3E0   		; part of initialization routine of BASIC
STX_BB_STY_BC	= $FDFB
STX_BA_STY_B9	= $FE02
LDX_22_LDY_23_DESTROY_B7BBBC = $E25D

;-------------------------------------------------------------------------------
; BASIC stub code with SYS line
; the line number and the byte before the end are reused as data and program code
;
	;.byte $0b	;we skip this byte because we start our file at address $802. 
			;The content of $801 is regenerated by BASIC relink routine
			;which is run automatically after loading
	.byte $08
        .byte <LINENUMBER,>LINENUMBER
        .byte $9e   ;SYS token
        .byte $30+SYSTARGET/1000
        .byte $30+SYSTARGET .mod 1000/100
        .byte $30+SYSTARGET .mod 100/10
        .byte $30+(SYSTARGET .mod 10)

	.byte $00	;end of line marker

;-------------------------------------------------------------------------------
; game code starts here
;
gamestart:	
	.assert gamestart = SYSTARGET, error, "you need to adjust the SYSTARGET address"

	;play sfx and set X to 0 afterwards
	;first time the game is run we hear a softer sound, it's a feature!

	ldx	$eb00	;the second byte of this MUST be 0 to serve as end of BASIC program marker
	;X contains now $0c
soundloop:
	lda	SOUNDSRC,x
	sta	$d400+14,x
	dex
	bpl	soundloop
	lda	#$80
        sta	$d412

	lda	#BLOCKS2HIT
	sta	blockcounter

	;X is $ff because of previous loop
	stx	balldx
	stx	balldy
.if ADD_OLD_ROM_FIX=0		;no fix
	jsr	PRINT_STARTUP_MSG
.elseif ADD_OLD_ROM_FIX=1	;cheap fix "green"
	dec	$d021
	jsr	PRINT_STARTUP_MSG
	inc	$d021
.elseif ADD_OLD_ROM_FIX=2	;proper fix
	dex			;X contains now $fe
	stx	$d021		;make screen light blue
	jsr	PRINT_STARTUP_MSG
	lda	#6
	sta	$d021		;make screen blue again
.endif

	ldy	#START_POS_X
	sty	paddlex
	sty	ballx
.if START_POS_X <> START_POS_Y
	ldy	#START_POS_Y
	.warning "START_POS_X <> START_POS_Y costs 2 byte"
.endif
	sty	paddley
	;dey	;was only necessary for START_POS_X=19
	sty	bally

gameloop:
	jsr load_paddle_positons

	;-----------------------------------------------------------------------
	; undraw paddle at current position

	lda	#' '
	jsr	draw3		;draw paddle with spaces = delete paddle, also loads paddle positions into x,y

	;-----------------------------------------------------------------------
	; read joystick and update position
	lda	$dc00
	lsr
	if cc
	  cpx	#MIN_Y+1
	  if cs
  	    dex			;one line up
	  endif
	endif
	lsr
	if cc
	  cpx #MAX_Y
	  if cc
  	    inx			;one line down
	  endif
	endif
	lsr
	if cc
	  cpy #MIN_X+1
	  if cs
  	    dey			;one column to the left
	  endif
	endif
	lsr
	if cc
	  cpy #MAX_X
	  if cc
  	    iny			;one column to the right
	  endif
	endif
	jsr	STX_BA_STY_B9	; Set paddly, paddlex

	;-----------------------------------------------------------------------
	; draw paddle at new position
	lda	#$A0
	jsr	draw3		;draw paddle with inverted spaces

	;-----------------------------------------------------------------------
	; ball movement only every 4th frame
	lda	$a2
	and 	#3
	bne	waitsync

	;-----------------------------------------------------------------------
	; ball movement and reflection on borders

	;clear the ball
	jsr	go_to_ball
	lda	after_hit_tile
	sta	($d1),y
	jsr	INIT_CHRGET	;reset after_hit_tile to $20

	ldx	#1		;pre-fill X with 1 needed for balldx and balldy
	lda	bally
	if eq
	  ;ldx	#1	  
	  stx   balldy
	endif
	cmp #24
	beq gamestart
	;clc			;not needed because we are in a line <24 here
	adc	balldy
	sta	bally

	lda	ballx
	if eq
	  ;ldx	#1
	  stx   balldx
	endif
	cmp #39
	if eq
	  ldx	#$ff
	  stx   balldx
	endif
	clc
	adc	balldx
	sta	ballx

	; ball reflection on objects and paddle
	jsr	go_to_ball
	lda	($d1),y		; Y has row, $d1 is pointer to current line.
	cmp	#$20		; Is it a space?
	if ne
	  cmp 	#160		; did we hit the paddle?
	  beq 	hit_paddle

	  ;code for character hit, play short sound
	  ldx 	#$41	;pulse waveform with gate bit on
	  stx 	$d414	;set sustain/release
	  stx 	$d412	;gate bit on
	  dec 	$d412	;gate bit off

	  if cc	;is not cracked ?
	    lda	level2_flag
	    sta	after_hit_tile
            bmi blocks_left
	  endif

	  dec 	blockcounter
	  bne 	blocks_left		;jmp if there are still blocks left

	  lda   #$e6	;cracked character sign
	  sta 	level2_flag
	  jmp 	gamestart
hit_paddle:
	  lda 	ballx
          clc			;we need to subtract 1 more
          sbc 	paddlex
	  sta 	balldx

blocks_left:
	  lda 	#0		;invert balldy
	  sec
	  sbc 	balldy
	  sta 	balldy
	endif
	;draw the ball
	lda	#$51
	sta	($d1),y
is_free_space:

waitsync:
	ldx #$81
:	cpx $d012
	bne :-
	dex
	bmi :-
	;cpx #$fd
	;bne :-

	jmp gameloop

draw3:	pha
	jsr PLOT_WITH_CLC
	pla
	ldx	#2
@l1:	sta	($d1),y
	iny
	dex
	bpl	@l1
		;fallthrough!
load_paddle_positons:
	ldx paddley ;current line
	ldy paddlex ;current column
	rts

go_to_ball:
	jsr	LDX_22_LDY_23_DESTROY_B7BBBC
	jmp 	PLOT_WITH_CLC	;tail call eliminated
